/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.kubejs;

import dev.latvian.mods.kubejs.error.KubeRuntimeException;
import dev.latvian.mods.kubejs.recipe.KubeRecipe;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentValue;
import dev.latvian.mods.rhino.Context;
import fr.frinn.custommachinery.api.crafting.IRecipeBuilder;
import fr.frinn.custommachinery.api.integration.jei.DisplayInfoTemplate;
import fr.frinn.custommachinery.api.integration.kubejs.RecipeJSBuilder;
import fr.frinn.custommachinery.api.requirement.IRequirement;
import fr.frinn.custommachinery.api.requirement.RecipeRequirement;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import org.slf4j.helpers.MessageFormatter;

public abstract class AbstractRecipeJSBuilder<B extends IRecipeBuilder<? extends Recipe<?>>>
extends KubeRecipe
implements RecipeJSBuilder {
    public final ResourceLocation typeID;
    private RecipeRequirement<?, ?> lastRequirement;
    public boolean jei = false;

    public AbstractRecipeJSBuilder(ResourceLocation typeID) {
        this.typeID = typeID;
    }

    public AbstractRecipeJSBuilder<B> jei() {
        this.jei = true;
        return this;
    }

    public AbstractRecipeJSBuilder<B> priority(Context cx, int priority) {
        if (!this.jei) {
            this.set(cx, "priority", priority);
        } else {
            this.set(cx, "jeiPriority", priority);
        }
        return this;
    }

    public AbstractRecipeJSBuilder<B> chance(double chance) {
        if (this.lastRequirement == null) {
            this.error("Can't set chance before adding requirements", new Object[0]);
        }
        this.lastRequirement.setChance(chance);
        return this;
    }

    public AbstractRecipeJSBuilder<B> info(Consumer<DisplayInfoTemplate> consumer) {
        if (this.lastRequirement == null) {
            this.error("Can't add info before adding requirements !", new Object[0]);
        }
        try {
            DisplayInfoTemplate template = new DisplayInfoTemplate();
            consumer.accept(template);
            this.lastRequirement.info = template;
        }
        catch (Exception e) {
            this.error("Error when adding custom display info on requirement {}\n{}", this.lastRequirement, e);
        }
        return this;
    }

    @Override
    public AbstractRecipeJSBuilder<B> delay(double delay) {
        if (this.lastRequirement == null) {
            this.error("Can't set delay before adding requirements", new Object[0]);
        }
        this.lastRequirement.setDelay(delay);
        return this;
    }

    @Override
    public AbstractRecipeJSBuilder<B> addRequirement(IRequirement<?> requirement) {
        this.lastRequirement = new RecipeRequirement(requirement);
        for (RecipeComponentValue value : this.getRecipeComponentValues()) {
            if (value.key.name.equals("requirements") && !this.jei) {
                this.setValue(value.key, this.addToList("requirements", this.lastRequirement));
                continue;
            }
            if (!value.key.name.equals("jei") || !this.jei) continue;
            this.setValue(value.key, this.addToList("jei", this.lastRequirement));
        }
        return this;
    }

    @Override
    public RecipeJSBuilder error(String error, Object ... args) {
        throw new KubeRuntimeException(MessageFormatter.arrayFormat((String)error, (Object[])args).getMessage()).source(this.sourceLine);
    }

    protected <E> List<E> addToList(String key, E element) {
        ArrayList<E> list = new ArrayList<E>((List)this.get(key));
        list.add(element);
        return list;
    }
}

