/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.component;

import fr.frinn.custommachinery.api.component.ComponentIOMode;
import fr.frinn.custommachinery.api.component.IMachineComponentManager;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.crafting.CraftingResult;
import fr.frinn.custommachinery.api.crafting.IProcessor;
import fr.frinn.custommachinery.common.crafting.machine.MachineProcessor;
import fr.frinn.custommachinery.common.crafting.machine.MachineProcessorCore;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.impl.component.AbstractMachineComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class WorkingCoreMachineComponent
extends AbstractMachineComponent {
    public WorkingCoreMachineComponent(IMachineComponentManager manager) {
        super(manager, ComponentIOMode.NONE);
    }

    public MachineComponentType<WorkingCoreMachineComponent> getType() {
        return Registration.WORKING_CORE_MACHINE_COMPONENT.get();
    }

    public CraftingResult isCoreWorking(int coreId, @Nullable ResourceLocation recipe, int currentCore) {
        IProcessor iProcessor = this.getManager().getTile().getProcessor();
        if (iProcessor instanceof MachineProcessor) {
            MachineProcessor processor = (MachineProcessor)iProcessor;
            if (coreId == 0) {
                if (recipe == null && processor.getCores().stream().noneMatch(core -> processor.getCores().indexOf(core) != currentCore && core.getCurrentRecipe() != null && core.getError() == null)) {
                    return CraftingResult.error((Component)Component.translatable((String)"custommachinery.requirements.working_core.all_idle"));
                }
                if (recipe != null && processor.getCores().stream().noneMatch(core -> processor.getCores().indexOf(core) != currentCore && core.getCurrentRecipe() != null && core.getCurrentRecipe().id().equals((Object)recipe))) {
                    return CraftingResult.error((Component)Component.translatable((String)"custommachinery.requirements.working_core.all_bad", (Object[])new Object[]{recipe.toString()}));
                }
                return CraftingResult.success();
            }
            if (coreId - 1 >= processor.getCores().size()) {
                return CraftingResult.error((Component)Component.translatable((String)"custommachinery.requirements.working_core.bad_core", (Object[])new Object[]{coreId, processor.getCores().size()}));
            }
            MachineProcessorCore core2 = processor.getCores().get(coreId - 1);
            if (core2.getCurrentRecipe() == null || core2.getError() != null) {
                return CraftingResult.error((Component)Component.translatable((String)"custommachinery.requirements.working_core.idle", (Object[])new Object[]{coreId}));
            }
            if (recipe != null && !core2.getCurrentRecipe().id().equals((Object)recipe)) {
                return CraftingResult.error((Component)Component.translatable((String)"custommachinery.requirements.working_core.bad_recipe", (Object[])new Object[]{coreId, recipe.toString()}));
            }
            return CraftingResult.success();
        }
        return CraftingResult.error((Component)Component.translatable((String)"custommachinery.requirements.working_core.bad_processor"));
    }
}

