/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.widget.config;

import com.mojang.blaze3d.systems.RenderSystem;
import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.impl.component.config.RelativeSide;
import fr.frinn.custommachinery.impl.component.config.SideConfig;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FastColor;

public class SideModeButton
extends ImageButton {
    private static final WidgetSprites SPRITES = new WidgetSprites(CustomMachinery.rl("config/side_mode_button"), CustomMachinery.rl("config/side_mode_button_hovered"));
    private final Supplier<SideConfig.SideMode> modeGetter;
    private final RelativeSide side;
    private final Button.OnPress leftClick;
    private final Button.OnPress rightClick;

    public SideModeButton(int x, int y, Supplier<SideConfig.SideMode> modeGetter, RelativeSide side, Button.OnPress leftClick, Button.OnPress rightClick) {
        super(x, y, 14, 14, SPRITES, button -> {}, side.getTranslationName());
        this.modeGetter = modeGetter;
        this.side = side;
        this.leftClick = leftClick;
        this.rightClick = rightClick;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int color = this.modeGetter.get().color();
        float r = (float)FastColor.ARGB32.red((int)color) / 255.0f;
        float g = (float)FastColor.ARGB32.green((int)color) / 255.0f;
        float b = (float)FastColor.ARGB32.blue((int)color) / 255.0f;
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
        super.renderWidget(graphics, mouseX, mouseY, partialTick);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.updateTooltips();
    }

    private void updateTooltips() {
        MutableComponent tooltip = Component.empty();
        tooltip.append(this.side.getTranslationName());
        tooltip.append("\n");
        tooltip.append(this.modeGetter.get().title());
        this.setTooltip(Tooltip.create((Component)tooltip));
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.clicked(mouseX, mouseY) || Minecraft.getInstance().player == null) {
            return false;
        }
        this.playDownSound(Minecraft.getInstance().getSoundManager());
        if (button == 0) {
            this.leftClick.onPress((Button)this);
        } else {
            this.rightClick.onPress((Button)this);
        }
        return true;
    }
}

