/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import org.joml.Quaternionf;

public class BoxRenderer {
    private final int time;
    private final long start;
    private final AABB box;

    public BoxRenderer(int time, AABB box) {
        this.time = time;
        this.start = System.currentTimeMillis();
        this.box = box.expandTowards(1.0, 1.0, 1.0);
    }

    public void render(PoseStack matrix, MultiBufferSource buffer, Direction machineFacing) {
        matrix.pushPose();
        matrix.translate(0.5f, 0.0f, 0.5f);
        matrix.mulPose(new Quaternionf().rotateY((float)Math.toRadians(-machineFacing.toYRot())));
        matrix.translate(-0.5f, 0.0f, -0.5f);
        LevelRenderer.renderLineBox((PoseStack)matrix, (VertexConsumer)buffer.getBuffer((RenderType)RenderType.LINES), (AABB)this.box, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        matrix.popPose();
    }

    public boolean shouldRender() {
        return System.currentTimeMillis() < this.start + (long)this.time;
    }
}

