/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.integration.jei.element;

import fr.frinn.custommachinery.api.crafting.IMachineRecipe;
import fr.frinn.custommachinery.api.integration.jei.IJEIElementRenderer;
import fr.frinn.custommachinery.client.ClientHandler;
import fr.frinn.custommachinery.common.guielement.FuelGuiElement;
import fr.frinn.custommachinery.common.requirement.FuelRequirement;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class FuelGuiElementJeiRenderer
implements IJEIElementRenderer<FuelGuiElement> {
    @Override
    public void renderElementInJEI(GuiGraphics graphics, FuelGuiElement element, IMachineRecipe recipe, int mouseX, int mouseY) {
        double percent = 1.0 - (double)(System.currentTimeMillis() % 2000L) / 2000.0;
        ClientHandler.renderOrientedProgressTextures(graphics, element.getEmptyTexture(), element.getFilledTexture(), element.getX(), element.getY(), element.getWidth(), element.getHeight(), percent, element.getOrientation());
    }

    @Override
    public List<Component> getJEITooltips(FuelGuiElement element, IMachineRecipe recipe) {
        int amount = recipe.getRequirements().stream().filter(requirement -> requirement.requirement() instanceof FuelRequirement).findFirst().map(requirement -> ((FuelRequirement)requirement.requirement()).amount()).orElse(0);
        ArrayList<Component> tooltips = new ArrayList<Component>(element.getTooltips());
        if (amount > 0) {
            tooltips.add((Component)Component.translatable((String)"custommachinery.jei.ingredient.fuel.amount", (Object[])new Object[]{amount}));
        }
        return tooltips;
    }
}

