/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.element;

import fr.frinn.custommachinery.api.crafting.IProcessor;
import fr.frinn.custommachinery.api.guielement.IMachineScreen;
import fr.frinn.custommachinery.api.machine.MachineStatus;
import fr.frinn.custommachinery.client.ClientHandler;
import fr.frinn.custommachinery.common.crafting.machine.MachineProcessor;
import fr.frinn.custommachinery.common.guielement.StatusGuiElement;
import fr.frinn.custommachinery.impl.guielement.AbstractGuiElementWidget;
import fr.frinn.custommachinery.impl.util.TextureInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class StatusGuiElementWidget
extends AbstractGuiElementWidget<StatusGuiElement> {
    public StatusGuiElementWidget(StatusGuiElement element, IMachineScreen screen) {
        super(element, screen, (Component)Component.literal((String)"Status"));
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        MachineStatus status = MachineStatus.IDLE;
        if (((StatusGuiElement)this.getElement()).getCore() == 0) {
            status = this.getScreen().getTile().getStatus();
        } else {
            MachineProcessor processor;
            IProcessor iProcessor = this.getScreen().getTile().getProcessor();
            if (iProcessor instanceof MachineProcessor && (processor = (MachineProcessor)iProcessor).getCores().size() >= ((StatusGuiElement)this.getElement()).getCore()) {
                status = processor.getCores().get(((StatusGuiElement)this.getElement()).getCore() - 1).getStatus();
            }
        }
        TextureInfo texture = switch (status) {
            case MachineStatus.RUNNING -> ((StatusGuiElement)this.getElement()).getRunningTexture();
            case MachineStatus.ERRORED -> ((StatusGuiElement)this.getElement()).getErroredTexture();
            default -> ((StatusGuiElement)this.getElement()).getIdleTexture();
        };
        ClientHandler.blit(graphics, texture, this.getX(), this.getY(), this.width, this.height);
    }

    @Override
    public List<Component> getTooltips() {
        MachineProcessor processor;
        if (!((StatusGuiElement)this.getElement()).getTooltips().isEmpty()) {
            return ((StatusGuiElement)this.getElement()).getTooltips();
        }
        ArrayList<Component> tooltips = new ArrayList<Component>();
        IProcessor iProcessor = this.getScreen().getTile().getProcessor();
        if (iProcessor instanceof MachineProcessor && (processor = (MachineProcessor)iProcessor).getCores().size() > 1) {
            processor.getCores().forEach(core -> {
                int index = processor.getCores().indexOf(core);
                if (core.getStatus() == MachineStatus.RUNNING) {
                    tooltips.add((Component)Component.empty().append((Component)Component.literal((String)"\u2713 ").withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)("Core " + index + ": "))).append((Component)Component.translatable((String)"custommachinery.craftingstatus.running")));
                } else if (core.getStatus() == MachineStatus.IDLE) {
                    tooltips.add((Component)Component.empty().append((Component)Component.literal((String)"|| ").withStyle(ChatFormatting.GOLD)).append((Component)Component.literal((String)("Core " + index + ": "))).append((Component)Component.translatable((String)"custommachinery.craftingstatus.idle")));
                }
                if (core.getStatus() == MachineStatus.ERRORED) {
                    tooltips.add((Component)Component.empty().append((Component)Component.literal((String)"X ").withStyle(ChatFormatting.DARK_RED)).append((Component)Component.literal((String)("Core " + index + ": "))).append((Component)Component.translatable((String)"custommachinery.craftingstatus.errored")));
                    if (core.getError() != null) {
                        tooltips.add((Component)Component.literal((String)"  - ").append(core.getError()));
                    }
                }
            });
        } else {
            tooltips.add((Component)Component.translatable((String)("custommachinery.craftingstatus." + this.getScreen().getTile().getStatus().toString().toLowerCase(Locale.ROOT))));
            if (this.getScreen().getTile().getStatus() == MachineStatus.ERRORED) {
                tooltips.add(this.getScreen().getTile().getMessage());
            }
        }
        return tooltips;
    }

    protected boolean clicked(double mouseX, double mouseY) {
        return false;
    }
}

