/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.element;

import fr.frinn.custommachinery.api.guielement.IMachineScreen;
import fr.frinn.custommachinery.client.ClientHandler;
import fr.frinn.custommachinery.common.guielement.BarGuiElement;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.impl.guielement.AbstractGuiElementWidget;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class BarGuiElementWidget
extends AbstractGuiElementWidget<BarGuiElement> {
    private static final Component TITLE = Component.literal((String)"Bar");

    public BarGuiElementWidget(BarGuiElement element, IMachineScreen screen) {
        super(element, screen, TITLE);
    }

    @Override
    public List<Component> getTooltips() {
        ArrayList<Component> tooltips = new ArrayList<Component>(((BarGuiElement)this.getElement()).getTooltips());
        this.getScreen().getTile().getComponentManager().getComponent(Registration.DATA_MACHINE_COMPONENT.get()).ifPresent(component -> tooltips.add((Component)Component.literal((String)String.format("%s / %s", component.getData().getDouble(((BarGuiElement)this.getElement()).getId()), ((BarGuiElement)this.getElement()).getMax()))));
        return tooltips;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        ClientHandler.renderOrientedProgressTextures(graphics, ((BarGuiElement)this.getElement()).getEmptyTexture(), ((BarGuiElement)this.getElement()).getFilledTexture(), this.getX(), this.getY(), this.width, this.height, this.getFillingPercent(), ((BarGuiElement)this.getElement()).getOrientation());
        if (this.isHovered() && ((BarGuiElement)this.getElement()).isHighlight()) {
            ClientHandler.renderSlotHighlight(graphics, this.getX() + 1, this.getY() + 1, this.width - 2, this.height - 2);
        }
    }

    private double getFillingPercent() {
        double amount = this.getScreen().getTile().getComponentManager().getComponent(Registration.DATA_MACHINE_COMPONENT.get()).map(component -> component.getData().getDouble(((BarGuiElement)this.getElement()).getId())).orElse(0.0);
        return (amount - (double)((BarGuiElement)this.getElement()).getMin()) / (double)((BarGuiElement)this.getElement()).getMax();
    }
}

