/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.recipe.jei;

import com.cyanogen.cognition.gui.MolecularMetamorpherMenu;
import com.cyanogen.cognition.network.shared.UpdateInventory;
import com.cyanogen.cognition.recipe.MolecularMetamorpherRecipe;
import com.cyanogen.cognition.recipe.jei.MolecularMetamorpherCategory;
import com.cyanogen.cognition.registries.RegisterMenus;
import java.util.ArrayList;
import java.util.Optional;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class MolecularMetamorpherTransferHandler
implements IRecipeTransferHandler<MolecularMetamorpherMenu, MolecularMetamorpherRecipe> {
    public final IRecipeTransferHandlerHelper helper;

    public MolecularMetamorpherTransferHandler(IRecipeTransferRegistration registration) {
        this.helper = registration.getTransferHelper();
    }

    public Class<? extends MolecularMetamorpherMenu> getContainerClass() {
        return MolecularMetamorpherMenu.class;
    }

    public Optional<MenuType<MolecularMetamorpherMenu>> getMenuType() {
        return Optional.of((MenuType)RegisterMenus.MOLECULAR_METAMORPHER_MENU.get());
    }

    public RecipeType<MolecularMetamorpherRecipe> getRecipeType() {
        return MolecularMetamorpherCategory.METAMORPHER_TYPE;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(MolecularMetamorpherMenu menu, MolecularMetamorpherRecipe recipe, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        if (recipe.isNameFormatting()) {
            return this.helper.createInternalError();
        }
        return this.checkAndTransfer(menu, recipe, recipeSlots, player, maxTransfer, doTransfer);
    }

    public IRecipeTransferError checkAndTransfer(MolecularMetamorpherMenu menu, MolecularMetamorpherRecipe recipe, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        ItemStack[] playerItems = new ItemStack[]{ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY};
        int[] playerItemCount = new int[]{0, 0, 0};
        int[] requiredCount = new int[]{0, 0, 0};
        IRecipeTransferError error = this.checkOnly(playerItems, playerItemCount, requiredCount, menu, recipe, player, recipeSlots);
        int[] countToTransfer = maxTransfer ? new int[]{Math.min(playerItemCount[0], playerItems[0].getMaxStackSize()), Math.min(playerItemCount[1], playerItems[1].getMaxStackSize()), Math.min(playerItemCount[2], playerItems[2].getMaxStackSize())} : requiredCount;
        if (error == null && doTransfer) {
            return this.transferOnly(playerItems, countToTransfer, menu, player);
        }
        return error;
    }

    public IRecipeTransferError checkOnly(ItemStack[] playerItems, int[] playerItemCount, int[] requiredCount, MolecularMetamorpherMenu menu, MolecularMetamorpherRecipe recipe, Player player, IRecipeSlotsView recipeSlots) {
        int[] spaces = new int[]{-1, -1, -1};
        for (int i = 0; i < 3; ++i) {
            ItemStack menuStack = menu.getSlot(i).getItem();
            if (menuStack.isEmpty()) {
                spaces[i] = 999;
                continue;
            }
            for (int k = 0; k < player.getInventory().items.size(); ++k) {
                ItemStack playerStack = player.getInventory().getItem(k);
                if (k == spaces[0] || k == spaces[1] || k == spaces[2]) continue;
                if (ItemStack.isSameItemSameComponents((ItemStack)menuStack, (ItemStack)playerStack) && menuStack.getCount() + playerStack.getCount() <= menuStack.getMaxStackSize()) {
                    spaces[i] = k;
                    continue;
                }
                if (!playerStack.isEmpty()) continue;
                spaces[i] = k;
            }
        }
        if (spaces[0] == -1 || spaces[1] == -1 || spaces[2] == -1) {
            return this.helper.createUserErrorWithTooltip((Component)Component.translatable((String)"jei.cognition.error.inventory_full"));
        }
        this.getItemInfo(playerItems, playerItemCount, requiredCount, menu, recipe, player);
        if (playerItemCount[0] >= requiredCount[0] && playerItemCount[1] >= requiredCount[1] && playerItemCount[2] >= requiredCount[2]) {
            return null;
        }
        ArrayList<IRecipeSlotView> slotsList = new ArrayList<IRecipeSlotView>();
        for (int i = 0; i < 3; ++i) {
            int slotNumber = i + 1;
            Optional slot = recipeSlots.findSlotByName("input" + slotNumber);
            if (playerItemCount[i] >= requiredCount[i] || !slot.isPresent()) continue;
            slotsList.add((IRecipeSlotView)slot.get());
        }
        MutableComponent component = Component.translatable((String)"jei.cognition.error.missing_items");
        return this.helper.createUserErrorForMissingSlots((Component)component, slotsList);
    }

    public IRecipeTransferError transferOnly(ItemStack[] playerItems, int[] countToTransfer, MolecularMetamorpherMenu menu, Player player) {
        int i;
        boolean uncleared = false;
        for (i = 0; i < 3; ++i) {
            ItemStack stack = menu.getSlot(i).getItem();
            if (stack.isEmpty() || playerItems[i].isEmpty() || countToTransfer[i] <= 0 || player.getInventory().add(stack)) continue;
            uncleared = true;
            break;
        }
        if (uncleared) {
            System.out.println("[Cognition JEI Plugin] Player inventory unexpectedly full");
            return this.helper.createInternalError();
        }
        block1: for (i = 0; i < 3; ++i) {
            ItemStack ingredientStack = playerItems[i];
            if (ingredientStack.isEmpty() || ingredientStack.is(Items.AIR) || countToTransfer[i] <= 0) continue;
            for (int k = 0; k < player.getInventory().items.size(); ++k) {
                ItemStack playerStack = player.getInventory().getItem(k);
                if (ItemStack.isSameItemSameComponents((ItemStack)playerStack, (ItemStack)ingredientStack)) {
                    int n = i;
                    countToTransfer[n] = countToTransfer[n] - menu.put(playerStack, countToTransfer[i]);
                }
                if (countToTransfer[i] <= 0) continue block1;
            }
        }
        this.updateContainerFromClient(player);
        return null;
    }

    public void getItemInfo(ItemStack[] playerItems, int[] playerItemCount, int[] requiredCount, MolecularMetamorpherMenu menu, MolecularMetamorpherRecipe recipe, Player player) {
        block0: for (int i = 1; i <= 3; ++i) {
            Ingredient ingredient = (Ingredient)recipe.getIngredients(true).get(i).getA();
            int count = (Integer)recipe.getIngredients(true).get(i).getB();
            int position = i - 1;
            requiredCount[position] = count;
            for (ItemStack ingredientStack : ingredient.getItems()) {
                playerItemCount[position] = 0;
                for (int j = 0; j < player.getInventory().items.size(); ++j) {
                    ItemStack playerStack = player.getInventory().getItem(j);
                    if (!ItemStack.isSameItemSameComponents((ItemStack)playerStack, (ItemStack)ingredientStack)) continue;
                    playerItems[position] = ingredientStack.copy();
                    int n = position;
                    playerItemCount[n] = playerItemCount[n] + playerStack.getCount();
                }
                for (int k = 0; k < 3; ++k) {
                    ItemStack menuStack = menu.getSlot(k).getItem();
                    if (!ItemStack.isSameItemSameComponents((ItemStack)menuStack, (ItemStack)ingredientStack)) continue;
                    playerItems[position] = ingredientStack.copy();
                    int n = position;
                    playerItemCount[n] = playerItemCount[n] + menuStack.getCount();
                }
                if (playerItemCount[position] >= count) continue block0;
            }
        }
    }

    public void updateContainerFromClient(Player player) {
        ListTag containerList = new ListTag();
        for (Slot slot : player.containerMenu.slots) {
            CompoundTag tag = (CompoundTag)slot.getItem().saveOptional((HolderLookup.Provider)player.level().registryAccess());
            containerList.add(slot.index, (Tag)tag);
        }
        CompoundTag containerTag = new CompoundTag();
        containerTag.put("Container", (Tag)containerList);
        PacketDistributor.sendToServer((CustomPacketPayload)new UpdateInventory(containerTag), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

