/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.recipe.jei;

import com.cyanogen.cognition.item.ExperienceFountainItem;
import com.cyanogen.cognition.recipe.FillingRecipe;
import com.cyanogen.cognition.registries.RegisterItems;
import com.cyanogen.cognition.utils.ExperienceUtils;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class FillingCategory
implements IRecipeCategory<FillingRecipe> {
    IRecipeCategoryRegistration registration;
    IGuiHelper guiHelper;
    public final ResourceLocation fillingBackground = ResourceLocation.parse((String)"cognition:textures/gui/recipes/filling_jei.png");
    public final ResourceLocation cognitiumTexture = ResourceLocation.parse((String)"cognition:textures/block/cognitium_still.png");
    public final IDrawableAnimated arrow;
    public final IDrawable cognitiumStack;
    private final int arrowWidth = 41;
    private final int arrowHeight = 7;
    private final int arrowOffsetX = 59;
    private final int arrowOffsetY = 21;
    private final int cognitiumOffsetX = 34;
    private final int cognitiumOffsetY = 18;
    public static final RecipeType<FillingRecipe> FILLING_TYPE = RecipeType.create((String)"cognition", (String)"filling", FillingRecipe.class);

    public FillingCategory(IRecipeCategoryRegistration registration) {
        this.registration = registration;
        this.guiHelper = registration.getJeiHelpers().getGuiHelper();
        this.arrow = this.guiHelper.drawableBuilder(this.fillingBackground, 0, 66, 41, 7).buildAnimated(100, IDrawableAnimated.StartDirection.LEFT, false);
        this.cognitiumStack = this.guiHelper.drawableBuilder(this.cognitiumTexture, 0, 0, 16, 16).build();
    }

    public RecipeType<FillingRecipe> getRecipeType() {
        return FILLING_TYPE;
    }

    public int getWidth() {
        return 136;
    }

    public int getHeight() {
        return 66;
    }

    public Component getTitle() {
        return Component.translatable((String)"jei.cognition.filling.title");
    }

    public IDrawable getIcon() {
        ItemStack icon = new ItemStack((ItemLike)RegisterItems.EXPERIENCE_FOUNTAIN_ITEM.get());
        return this.guiHelper.createDrawableItemStack(icon);
    }

    public void draw(FillingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.guiHelper.createDrawable(this.fillingBackground, 0, 0, 136, 66).draw(guiGraphics);
        this.arrow.draw(guiGraphics, 59, 21);
        if (recipe.getCognitiumCost() > 0) {
            this.cognitiumStack.draw(guiGraphics, 34, 18);
        }
        super.draw((Object)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
    }

    public void getTooltip(ITooltipBuilder tooltipBuilder, FillingRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        this.getArrowTooltip(tooltipBuilder, mouseX, mouseY);
        this.getCognitiumTooltip(recipe.getCognitiumCost(), tooltipBuilder, mouseX, mouseY);
        super.getTooltip(tooltipBuilder, (Object)recipe, recipeSlotsView, mouseX, mouseY);
    }

    public void getArrowTooltip(ITooltipBuilder tooltipBuilder, double mouseX, double mouseY) {
        MutableComponent arrowTooltip = Component.translatable((String)"jei.cognition.filling.tooltip");
        int x1 = 56;
        int x2 = 103;
        int y1 = 19;
        int y2 = 30;
        if (mouseX >= (double)x1 && mouseX <= (double)x2 && mouseY >= (double)y1 && mouseY <= (double)y2) {
            tooltipBuilder.add((FormattedText)arrowTooltip);
        }
    }

    public void getCognitiumTooltip(int cognitiumCost, ITooltipBuilder tooltipBuilder, double mouseX, double mouseY) {
        int x1 = 34;
        int x2 = x1 + 16;
        int y1 = 18;
        int y2 = y1 + 16;
        if (cognitiumCost > 0 && mouseX >= (double)x1 && mouseX <= (double)x2 && mouseY >= (double)y1 && mouseY <= (double)y2) {
            int xp = cognitiumCost / 20;
            int levels = ExperienceUtils.xpToLevels(xp);
            MutableComponent volumeComponent = Component.translatable((String)"jei.cognition.shared.cognitium_amount.mb", (Object[])new Object[]{Component.literal((String)String.valueOf(cognitiumCost)).withStyle(ChatFormatting.GREEN)});
            MutableComponent xpLevelsComponent = Component.translatable((String)"jei.cognition.shared.cognitium_amount.levels_xp", (Object[])new Object[]{Component.literal((String)String.valueOf(levels)).withStyle(ChatFormatting.GREEN), Component.literal((String)String.valueOf(xp)).withStyle(ChatFormatting.GREEN)});
            tooltipBuilder.add((FormattedText)volumeComponent);
            tooltipBuilder.add((FormattedText)xpLevelsComponent);
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FillingRecipe recipe, IFocusGroup focuses) {
        ItemStack catalyst = ((ExperienceFountainItem)((Object)RegisterItems.EXPERIENCE_FOUNTAIN_ITEM.get())).getDefaultInstance();
        builder.addSlot(RecipeIngredientRole.INPUT, 10, 18).setSlotName("input").addIngredients(recipe.getIngredient());
        builder.addSlot(RecipeIngredientRole.CATALYST, 71, 34).setSlotName("catalyst").addItemStack(catalyst);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 110, 18).setSlotName("output").addItemStack(recipe.getResultItem(null));
    }
}

