/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.recipe.jei;

import com.cyanogen.cognition.gui.MolecularMetamorpherScreen;
import com.cyanogen.cognition.recipe.EmptyingRecipe;
import com.cyanogen.cognition.recipe.FillingRecipe;
import com.cyanogen.cognition.recipe.InfectingRecipe;
import com.cyanogen.cognition.recipe.MolecularMetamorpherRecipe;
import com.cyanogen.cognition.recipe.jei.EmptyingCategory;
import com.cyanogen.cognition.recipe.jei.FillingCategory;
import com.cyanogen.cognition.recipe.jei.InfectingCategory;
import com.cyanogen.cognition.recipe.jei.MolecularMetamorpherCategory;
import com.cyanogen.cognition.recipe.jei.MolecularMetamorpherTransferHandler;
import com.cyanogen.cognition.registries.RegisterItems;
import com.cyanogen.cognition.utils.RecipeUtils;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class CognitionJeiPlugin
implements IModPlugin {
    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new MolecularMetamorpherCategory(registration)});
        registration.addRecipeCategories(new IRecipeCategory[]{new InfectingCategory(registration)});
        registration.addRecipeCategories(new IRecipeCategory[]{new FillingCategory(registration)});
        registration.addRecipeCategories(new IRecipeCategory[]{new EmptyingCategory(registration)});
        super.registerCategories(registration);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ArrayList<MolecularMetamorpherRecipe> metamorpherRecipes = new ArrayList<MolecularMetamorpherRecipe>();
        ArrayList<InfectingRecipe> infectingRecipes = new ArrayList<InfectingRecipe>();
        ArrayList<FillingRecipe> fillingRecipes = new ArrayList<FillingRecipe>();
        ArrayList<EmptyingRecipe> emptyingRecipes = new ArrayList<EmptyingRecipe>();
        assert (Minecraft.getInstance().level != null);
        Collection recipes = Minecraft.getInstance().level.getRecipeManager().getRecipes();
        for (RecipeHolder recipe : recipes) {
            Recipe recipe2;
            Objects.requireNonNull(recipe.value());
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MolecularMetamorpherRecipe.class, InfectingRecipe.class, FillingRecipe.class, EmptyingRecipe.class}, (Object)recipe2, n)) {
                case 0: {
                    MolecularMetamorpherRecipe k = (MolecularMetamorpherRecipe)recipe2;
                    metamorpherRecipes.add(k);
                    break;
                }
                case 1: {
                    InfectingRecipe j = (InfectingRecipe)recipe2;
                    infectingRecipes.add(j);
                    break;
                }
                case 2: {
                    FillingRecipe l = (FillingRecipe)recipe2;
                    fillingRecipes.add(l);
                    break;
                }
                case 3: {
                    EmptyingRecipe m = (EmptyingRecipe)recipe2;
                    emptyingRecipes.add(m);
                    break;
                }
            }
        }
        metamorpherRecipes.add(RecipeUtils.getEmptyNameFormattingRecipe());
        registration.addRecipes(MolecularMetamorpherCategory.METAMORPHER_TYPE, metamorpherRecipes);
        registration.addRecipes(InfectingCategory.INFECTING_TYPE, infectingRecipes);
        registration.addRecipes(FillingCategory.FILLING_TYPE, fillingRecipes);
        registration.addRecipes(EmptyingCategory.EMPTYING_TYPE, emptyingRecipes);
        ItemStack forgottenDust = new ItemStack((ItemLike)RegisterItems.FORGOTTEN_DUST.get());
        registration.addIngredientInfo((Object)forgottenDust, (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"jei.cognition.description.forgotten_dust")});
        ArrayList<ItemStack> hidden = new ArrayList<ItemStack>();
        hidden.add(((Item)RegisterItems.DUMMY_SWORD.get()).getDefaultInstance());
        registration.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, hidden);
        super.registerRecipes(registration);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((ItemLike)RegisterItems.MOLECULAR_METAMORPHER_ITEM.get(), new RecipeType[]{MolecularMetamorpherCategory.METAMORPHER_TYPE});
        registration.addRecipeCatalyst((ItemLike)RegisterItems.EXPERIENCE_FOUNTAIN_ITEM.get(), new RecipeType[]{FillingCategory.FILLING_TYPE});
        registration.addRecipeCatalyst((ItemLike)RegisterItems.EXPERIENCE_FOUNTAIN_ITEM.get(), new RecipeType[]{EmptyingCategory.EMPTYING_TYPE});
        registration.addRecipeCatalysts(InfectingCategory.INFECTING_TYPE, (IIngredientType)VanillaTypes.ITEM_STACK, RecipeUtils.getCatalysts());
        super.registerRecipeCatalysts(registration);
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new MolecularMetamorpherTransferHandler(registration), MolecularMetamorpherCategory.METAMORPHER_TYPE);
        super.registerRecipeTransferHandlers(registration);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(MolecularMetamorpherScreen.class, 107, 45, 32, 10, new RecipeType[]{MolecularMetamorpherCategory.METAMORPHER_TYPE});
        super.registerGuiHandlers(registration);
    }

    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"cognition", (String)"jei_plugin");
    }
}

