/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class FormatUtil {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("###,###,###,###,###", DecimalFormatSymbols.getInstance(Locale.ROOT));

    public static String formatNumber(double value) {
        if (Math.abs(value) < 1000.0) {
            return String.valueOf(value);
        }
        if (Math.abs(value) < 1000000.0) {
            return FormatUtil.addCommas((int)value);
        }
        if (Math.abs(value) < 1.0E9) {
            return (double)Math.round(value / 1000.0) / 1000.0 + "M";
        }
        if (Math.abs(value) < 1.0E12) {
            return (double)Math.round(value / 1000000.0) / 1000.0 + "G";
        }
        return (double)Math.round(value / 1.0E9) / 1000.0 + "T";
    }

    public static String formatNumber(long value) {
        if (value == Long.MIN_VALUE) {
            value = Long.MAX_VALUE;
        }
        if (Math.abs(value) < 1000L) {
            return String.valueOf(value);
        }
        if (Math.abs(value) < 1000000L) {
            return FormatUtil.addCommas(value);
        }
        if (Math.abs(value) < 1000000000L) {
            return (double)Math.round((double)(value / 100000L)) / 10.0 + "M";
        }
        if (Math.abs(value) < 1000000000000L) {
            return (double)Math.round((double)(value / 100000000L)) / 10.0 + "G";
        }
        if (Math.abs(value) < 1000000000000000L) {
            return (double)Math.round((double)(value / 1000000000L)) / 1000.0 + "T";
        }
        if (Math.abs(value) < 1000000000000000000L) {
            return (double)Math.round((double)(value / 1000000000000L)) / 1000.0 + "P";
        }
        return (double)Math.round((double)(value / 1000000000000000L)) / 1000.0 + "E";
    }

    public static String addCommas(int value) {
        return DECIMAL_FORMAT.format(value);
    }

    public static String addCommas(long value) {
        return DECIMAL_FORMAT.format(value);
    }
}

