/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.inventory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class MappedInventoryAccess
implements Container {
    public static final InventoryAccessor fullAccess = slot -> true;
    private final ArrayList<Integer> slotMap = new ArrayList();
    private final Container inv;
    private final ArrayList<InventoryAccessor> accessors = new ArrayList();

    public MappedInventoryAccess(Container inv, InventoryAccessor ... accessors) {
        this.inv = inv;
        Collections.addAll(this.accessors, accessors);
        this.reset();
    }

    public void reset() {
        this.slotMap.clear();
        block0: for (int i = 0; i < this.inv.getContainerSize(); ++i) {
            for (InventoryAccessor a : this.accessors) {
                if (a.canAccessSlot(i)) continue;
                continue block0;
            }
            this.slotMap.add(i);
        }
    }

    public int getContainerSize() {
        return this.slotMap.size();
    }

    public boolean isEmpty() {
        return this.inv.isEmpty();
    }

    public ItemStack getItem(int slot) {
        return this.inv.getItem(this.slotMap.get(slot).intValue());
    }

    public ItemStack removeItem(int slot, int amount) {
        return this.inv.removeItem(this.slotMap.get(slot).intValue(), amount);
    }

    public ItemStack removeItemNoUpdate(int slot) {
        return this.inv.removeItemNoUpdate(this.slotMap.get(slot).intValue());
    }

    public void setItem(int slot, ItemStack stack) {
        this.inv.setItem(this.slotMap.get(slot).intValue(), stack);
    }

    public int getMaxStackSize() {
        return this.inv.getMaxStackSize();
    }

    public void setChanged() {
        this.inv.setChanged();
    }

    public boolean stillValid(Player player) {
        return this.inv.stillValid(player);
    }

    public void addAccessor(InventoryAccessor accessor) {
        this.accessors.add(accessor);
        this.reset();
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        return this.inv.canPlaceItem(this.slotMap.get(slot).intValue(), stack);
    }

    public void startOpen(Player player) {
        this.inv.startOpen(player);
    }

    public void stopOpen(Player player) {
        this.inv.stopOpen(player);
    }

    public void clearContent() {
        this.inv.clearContent();
    }

    public List<InventoryAccessor> accessors() {
        return this.accessors;
    }

    public static interface InventoryAccessor {
        public boolean canAccessSlot(int var1);
    }
}

