/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.clavis.common.data;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;

public class TooltipInfoData {
    List<FormattedCharSequence> summary;
    List<FormattedCharSequence> description;
    int summaryLength;
    int descriptionLength;

    public TooltipInfoData(Font font, String infoPath, int maxLength) {
        MutableComponent title = Component.translatable((String)("ui.clavis." + infoPath + ".summary")).withStyle(ChatFormatting.BOLD);
        this.summary = new ArrayList<FormattedCharSequence>(font.split((FormattedText)title, maxLength));
        this.summary.add(Component.empty().getVisualOrderText());
        this.summary.add(Component.translatable((String)"ui.clavis.hold_shift").withStyle(ChatFormatting.ITALIC).getVisualOrderText());
        this.description = new ArrayList<FormattedCharSequence>(font.split((FormattedText)Component.translatable((String)("ui.clavis." + infoPath + ".description")), maxLength));
        this.description.addFirst(Component.empty().getVisualOrderText());
        this.description.addFirst(title.getVisualOrderText());
        this.summaryLength = this.summary.stream().mapToInt(arg_0 -> ((Font)font).width(arg_0)).max().getAsInt();
        this.descriptionLength = this.description.stream().mapToInt(arg_0 -> ((Font)font).width(arg_0)).max().getAsInt();
    }

    public List<FormattedCharSequence> getSummary() {
        return this.summary;
    }

    public List<FormattedCharSequence> getDescription() {
        return this.description;
    }

    public int getSummaryLength() {
        return this.summaryLength;
    }

    public int getDescriptionLength() {
        return this.descriptionLength;
    }
}

