/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.clavis.common.client.screen.widget;

import com.mojang.math.Axis;
import it.hurts.octostudios.octolib.client.screen.widget.Child;
import it.hurts.octostudios.octolib.client.screen.widget.HasRenderMatrix;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class RotatingParent<T extends Child<RotatingParent>, C extends LayoutElement>
extends AbstractWidget
implements HasRenderMatrix,
ContainerEventHandler,
Child<C> {
    C parent;
    Matrix4f matrix;
    List<T> children = new ArrayList<T>();
    GuiEventListener focused;
    boolean dragging;
    float rot;

    @SafeVarargs
    public RotatingParent(int x, int y, float degrees, T ... children) {
        super(x, y, 0, 0, (Component)Component.empty());
        this.setRot(degrees);
        this.children.addAll(Arrays.stream(children).peek(child -> child.setParent((LayoutElement)this)).toList());
    }

    @NotNull
    public List<? extends GuiEventListener> children() {
        return this.children;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public void setDragging(boolean isDragging) {
        this.dragging = isDragging;
    }

    @Nullable
    public GuiEventListener getFocused() {
        return this.focused;
    }

    public void setFocused(@Nullable GuiEventListener focused) {
        this.focused = focused;
    }

    public Matrix4f getMatrix() {
        return this.matrix;
    }

    public void setMatrix(Matrix4f matrix) {
        this.matrix = matrix;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return super.mouseClicked(mouseX, mouseY, button);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)this.getX(), (float)this.getY(), 0.0f);
        guiGraphics.pose().mulPose(Axis.ZP.rotationDegrees(this.rot));
        guiGraphics.pose().translate((float)(-this.getX()), (float)(-this.getY()), 0.0f);
        this.setMatrix(new Matrix4f((Matrix4fc)guiGraphics.pose().last().pose()));
        this.children.forEach(child -> {
            if (child instanceof Renderable) {
                Renderable renderable = (Renderable)child;
                renderable.render(guiGraphics, mouseX, mouseY, partialTick);
            }
        });
        guiGraphics.pose().popPose();
    }

    @Nullable
    public C getParent() {
        return this.parent;
    }

    public void setParent(@Nullable C c) {
        this.parent = c;
    }

    public float getRot() {
        return this.rot;
    }

    public void setRot(float rot) {
        this.rot = rot;
    }
}

