/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.clavis.common.client.particle;

import it.hurts.octostudios.octolib.client.particle.ExtendedUIParticle;
import it.hurts.octostudios.octolib.client.particle.UIParticle;
import it.hurts.shatterbyte.clavis.common.Clavis;
import java.util.List;
import java.util.Random;
import net.minecraft.util.Mth;
import org.joml.Vector2f;
import org.joml.Vector2fc;

public class MeteorPartUIParticle
extends ExtendedUIParticle {
    public static final UIParticle.Texture2D PART_1 = new UIParticle.Texture2D(Clavis.path("textures/particle/meteor_projectile_1.png"), 5, 5);
    public static final UIParticle.Texture2D PART_2 = new UIParticle.Texture2D(Clavis.path("textures/particle/meteor_projectile_2.png"), 4, 4);
    public static final UIParticle.Texture2D PART_3 = new UIParticle.Texture2D(Clavis.path("textures/particle/meteor_projectile_3.png"), 3, 3);
    public static final UIParticle.Texture2D PART_4 = new UIParticle.Texture2D(Clavis.path("textures/particle/meteor_projectile_4.png"), 2, 2);
    public static final List<UIParticle.Texture2D> PARTS = List.of(PART_1, PART_2, PART_3, PART_4);

    public static UIParticle.Texture2D getRandomPart(Random random) {
        return PARTS.get(random.nextInt(PARTS.size() - 1));
    }

    public MeteorPartUIParticle(UIParticle.Texture2D texture, int lifetime, float meteorCenterX, float meteorCenterY, float spread, UIParticle.Layer layer, float zOffset) {
        super(texture, 2.0f, lifetime, meteorCenterX, meteorCenterY, layer, zOffset);
        Random random = new Random();
        if (spread != 0.0f) {
            float halfSpread = spread / 2.0f;
            this.getTransform().getPosition().add(random.nextFloat(-halfSpread, halfSpread), random.nextFloat(-halfSpread, halfSpread));
        }
        this.setDirection(new Vector2f((Vector2fc)this.getTransform().getPosition()).sub(meteorCenterX, meteorCenterY));
        this.setSpeed(random.nextFloat(0.5f, 2.0f));
        this.setFriction(0.025f);
        this.getTransform().setRoll(random.nextFloat(0.0f, 360.0f));
        this.getTransform().updateOldValues();
        this.setRollVelocity(random.nextFloat(-30.0f, 30.0f));
        this.enableBlend(false);
    }

    public void tick() {
        super.tick();
        float timeRatio = 1.0f - this.getTimeRatio(0.0f);
        timeRatio *= 1.5f;
        timeRatio = Mth.clamp((float)timeRatio, (float)0.0f, (float)1.0f);
        this.getTransform().getSize().mul(timeRatio);
    }
}

