/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.util;

import chanceCubes.CCubesCore;
import chanceCubes.config.CCubesSettings;
import chanceCubes.mcwrapper.ComponentWrapper;
import chanceCubes.rewards.rewardparts.CommandPart;
import chanceCubes.util.CustomEntry;
import chanceCubes.util.GuiTextLocation;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.StreamSupport;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;

public class RewardsUtil {
    public static final TagKey<Item> BLACKLIST = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"chancecubes", (String)"blacklist"));
    private static final List<String> oredicts = new ArrayList<String>();
    private static final String[] possibleModOres = new String[]{"ores/aluminum", "ores/copper", "ores/mythril", "ores/lead", "ores/plutonium", "ores/quartz", "ores/ruby", "ores/salt", "ores/sapphire", "ores/silver", "ores/tin", "ores/uranium", "ores/zinc"};
    public static final Random rand = new Random();
    private static final Block[] wools = new Block[]{Blocks.WHITE_WOOL, Blocks.ORANGE_WOOL, Blocks.MAGENTA_WOOL, Blocks.LIGHT_BLUE_WOOL, Blocks.LIME_WOOL, Blocks.PINK_WOOL, Blocks.GRAY_WOOL, Blocks.LIGHT_GRAY_WOOL, Blocks.CYAN_WOOL, Blocks.PURPLE_WOOL, Blocks.BLUE_WOOL, Blocks.BROWN_WOOL, Blocks.GREEN_WOOL, Blocks.RED_WOOL, Blocks.BLACK_WOOL};

    public static List<String> getOreDicts() {
        return oredicts;
    }

    public static void initData() {
        oredicts.add("ores/gold");
        oredicts.add("ores/iron");
        oredicts.add("ores/lapis");
        oredicts.add("ores/diamond");
        oredicts.add("ores/redstone");
        oredicts.add("ores/emerald");
        oredicts.add("ores/quartz");
        oredicts.add("ores/coal");
        for (String oreDict : possibleModOres) {
            if (!BuiltInRegistries.BLOCK.getTagOrEmpty(RewardsUtil.getTagKey(ResourceLocation.fromNamespaceAndPath((String)"c", (String)oreDict))).iterator().hasNext()) continue;
            oredicts.add(oreDict);
        }
    }

    public static CommandPart[] executeXCommands(String command, int amount) {
        CommandPart[] toReturn = new CommandPart[amount];
        for (int i = 0; i < amount; ++i) {
            toReturn[i] = new CommandPart(command);
        }
        return toReturn;
    }

    public static CommandPart[] executeXCommands(String command, int amount, int delay) {
        CommandPart[] toReturn = new CommandPart[amount];
        for (int i = 0; i < amount; ++i) {
            CommandPart part = new CommandPart(command);
            part.setDelay(delay);
            toReturn[i] = part;
        }
        return toReturn;
    }

    public static void sendMessageToNearPlayers(Level level, BlockPos pos, int distance, String message) {
        for (int i = 0; i < level.players().size(); ++i) {
            Player entityplayer = (Player)level.players().get(i);
            double dist = Math.sqrt(Math.pow((double)pos.getX() - entityplayer.getX(), 2.0) + Math.pow((double)pos.getY() - entityplayer.getY(), 2.0) + Math.pow((double)pos.getZ() - entityplayer.getZ(), 2.0));
            if (!(dist <= (double)distance)) continue;
            RewardsUtil.sendMessageToPlayer(entityplayer, message);
        }
    }

    public static void sendMessageToAllPlayers(Level level, String message) {
        for (int i = 0; i < level.players().size(); ++i) {
            Player entityplayer = (Player)level.players().get(i);
            RewardsUtil.sendMessageToPlayer(entityplayer, message);
        }
    }

    public static void sendMessageToPlayer(Player player, String message) {
        if (player != null) {
            RewardsUtil.sendMessageToPlayer(player, (Component)ComponentWrapper.string(message));
        }
    }

    public static void sendMessageToPlayer(Player player, Component message) {
        if (player != null) {
            player.sendSystemMessage(message);
        }
    }

    public static ItemStack getItemStack(String mod, String itemName, int size) {
        Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)mod, (String)itemName));
        return item == null ? ItemStack.EMPTY : new ItemStack((ItemLike)item, size);
    }

    public static Block getBlock(String mod, String blockName) {
        return (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)mod, (String)blockName));
    }

    public static boolean placeBlock(BlockState b, Level level, BlockPos pos) {
        return RewardsUtil.placeBlock(b, level, pos, 3, false);
    }

    public static boolean placeBlock(BlockState b, Level level, BlockPos pos, boolean ignoreUnbreakable) {
        return RewardsUtil.placeBlock(b, level, pos, 3, ignoreUnbreakable);
    }

    public static boolean placeBlock(BlockState b, Level level, BlockPos pos, int update, boolean ignoreUnbreakable) {
        if (!RewardsUtil.isBlockUnbreakable(level, pos) || ignoreUnbreakable) {
            level.setBlock(pos, b, update);
            return true;
        }
        return false;
    }

    public static boolean isBlockUnbreakable(Level level, BlockPos pos) {
        return level.getBlockState(pos).getDestroySpeed((BlockGetter)level, pos) == -1.0f || CCubesSettings.nonReplaceableBlocks.contains(level.getBlockState(pos));
    }

    public static Holder<MobEffect> getPotionSafe(ResourceLocation res) {
        return RewardsUtil.getRegistryHolderEntrySafe(BuiltInRegistries.MOB_EFFECT, res, MobEffects.MOVEMENT_SPEED.getKey().location());
    }

    public static ParticleType<?> getParticleSafe(ResourceLocation res) {
        return (ParticleType)RewardsUtil.getRegistryEntrySafe(BuiltInRegistries.PARTICLE_TYPE, res, BuiltInRegistries.PARTICLE_TYPE.getKey((Object)ParticleTypes.BLOCK));
    }

    public static <T> T getRegistryEntrySafe(Registry<T> registry, ResourceLocation key, ResourceLocation defaultReturn) {
        Object val = registry.get(key);
        return (T)(val == null ? registry.get(defaultReturn) : val);
    }

    public static <T> Holder<T> getRegistryHolderEntrySafe(Registry<T> registry, ResourceLocation key, ResourceLocation defaultReturn) {
        Holder val = registry.getHolder(key).orElse(null);
        return val == null ? (Holder)registry.getHolder(defaultReturn).get() : val;
    }

    public static Block getRandomOre() {
        return RewardsUtil.getRandomOre(new ArrayList<String>());
    }

    public static Block getRandomOre(List<String> blacklist) {
        return RewardsUtil.getRandomOreFromOreDict(RewardsUtil.getRandomOreDict(blacklist));
    }

    public static Block getRandomOreFromOreDict(String oreDict) {
        return RewardsUtil.getRandomElement(BuiltInRegistries.BLOCK.getTagOrEmpty(RewardsUtil.getTagKey(ResourceLocation.fromNamespaceAndPath((String)"c", (String)oreDict))));
    }

    private static Block getRandomElement(Iterable<Holder<Block>> it) {
        List<Holder<Block>> result = StreamSupport.stream(it.spliterator(), false).toList();
        return (Block)result.get(rand.nextInt(result.size())).value();
    }

    private static TagKey<Block> getTagKey(ResourceLocation res) {
        return TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)res);
    }

    public static Block getRandomBlock() {
        return RewardsUtil.randomRegistryEntry(BuiltInRegistries.BLOCK, Blocks.COBBLESTONE);
    }

    public static Item getRandomItem() {
        Item item;
        while ((item = RewardsUtil.randomRegistryEntry(BuiltInRegistries.ITEM, Items.APPLE)) == null || !item.isEnabled(FeatureFlags.VANILLA_SET) || item.getDefaultInstance().is(BLACKLIST)) {
        }
        return item;
    }

    public static Holder<Enchantment> randomEnchantment(HolderLookup.Provider provider) {
        List entries = provider.lookupOrThrow(Registries.ENCHANTMENT).listElements().toList();
        Holder entry = entries.stream().skip(rand.nextInt(entries.size())).findFirst().orElse(null);
        int iteration = 0;
        while (entry == null) {
            if (++iteration > 100) {
                return provider.holderOrThrow(Enchantments.SHARPNESS);
            }
            entry = entries.stream().skip(rand.nextInt(entries.size())).findFirst().orElse(null);
        }
        return entry;
    }

    public static CustomEntry<Holder<Enchantment>, Integer> getRandomEnchantmentAndLevel(HolderLookup.Provider provider) {
        Holder<Enchantment> ench = RewardsUtil.randomEnchantment(provider);
        int level = rand.nextInt(((Enchantment)ench.value()).getMaxLevel()) + ((Enchantment)ench.value()).getMinLevel();
        return new CustomEntry<Holder<Enchantment>, Integer>(ench, level);
    }

    public static Holder<MobEffect> getRandomPotionEffect() {
        return RewardsUtil.randomRegistryHolderEntry(BuiltInRegistries.MOB_EFFECT, MobEffects.GLOWING);
    }

    public static MobEffectInstance getRandomPotionEffectInstance() {
        Holder<MobEffect> effect = RewardsUtil.getRandomPotionEffect();
        int duration = ((int)Math.round(Math.abs(rand.nextGaussian()) * 5.0) + 3) * 20;
        int amplifier = (int)Math.round(Math.abs(rand.nextGaussian() * 1.5));
        return new MobEffectInstance(effect, duration, amplifier);
    }

    public static Potion getRandomPotionType() {
        return RewardsUtil.randomRegistryEntry(BuiltInRegistries.POTION, (Potion)Potions.WATER.value());
    }

    public static <T> T randomRegistryEntry(Registry<T> registry, T defaultReturn) {
        List entries = registry.stream().toList();
        Object entry = entries.stream().skip(rand.nextInt(entries.size())).findFirst().orElse(null);
        int iteration = 0;
        while (entry == null) {
            if (++iteration > 100) {
                return defaultReturn;
            }
            entry = entries.stream().skip(rand.nextInt(entries.size())).findFirst().orElse(null);
        }
        return entry;
    }

    public static <T> Holder<T> randomRegistryHolderEntry(Registry<T> registry, Holder<T> defaultReturn) {
        List entries = registry.holders().toList();
        Holder entry = entries.stream().skip(rand.nextInt(entries.size())).findFirst().orElse(null);
        int iteration = 0;
        while (entry == null) {
            if (++iteration > 100) {
                return defaultReturn;
            }
            entry = entries.stream().skip(rand.nextInt(entries.size())).findFirst().orElse(null);
        }
        return entry;
    }

    public static ItemStack getRandomFirework(HolderLookup.Provider provider) {
        ItemStack stack = new ItemStack((ItemLike)Items.FIREWORK_ROCKET);
        CompoundTag data = new CompoundTag();
        data.putInt("Flight", rand.nextInt(3) + 1);
        ListTag explosionList = new ListTag();
        for (int i = 0; i <= rand.nextInt(2); ++i) {
            CompoundTag explosionData = new CompoundTag();
            explosionData.putInt("Type", rand.nextInt(5));
            explosionData.putBoolean("Flicker", rand.nextBoolean());
            explosionData.putBoolean("Trail", rand.nextBoolean());
            int[] colors = new int[rand.nextInt(2) + 1];
            for (int j = 0; j < colors.length; ++j) {
                colors[j] = RewardsUtil.getRandomColor();
            }
            explosionData.putIntArray("Colors", colors);
            int[] fadeColors = new int[rand.nextInt(2) + 1];
            for (int j = 0; j < fadeColors.length; ++j) {
                fadeColors[j] = RewardsUtil.getRandomColor();
            }
            explosionData.putIntArray("FadeColors", fadeColors);
            explosionList.add((Object)explosionData);
        }
        data.put("Explosions", (Tag)explosionList);
        CompoundTag nbt = new CompoundTag();
        nbt.put("Fireworks", (Tag)data);
        Fireworks.CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)nbt).resultOrPartial(string -> CCubesCore.logger.error("Failed to parse fireworks: '{}'", string)).ifPresent(firework -> stack.set(DataComponents.FIREWORKS, firework));
        return stack;
    }

    public static String getRandomOreDict() {
        return RewardsUtil.getRandomOreDict(new ArrayList<String>());
    }

    public static String getRandomOreDict(List<String> blacklist) {
        List<String> oredicts = RewardsUtil.getOreDicts().stream().filter(line -> !blacklist.contains(line)).toList();
        return oredicts.size() > 0 ? oredicts.get(rand.nextInt(oredicts.size())) : "ores/coal";
    }

    public static Fluid getRandomFluid(boolean onlySources) {
        Fluid fluid;
        do {
            fluid = (Fluid)RewardsUtil.randomRegistryEntry(BuiltInRegistries.FLUID, Fluids.WATER);
        } while (onlySources && !fluid.isSource(fluid.defaultFluidState()));
        return fluid;
    }

    public static int getRandomColor() {
        return new Color(rand.nextInt(256), rand.nextInt(256), rand.nextInt(256)).getRGB();
    }

    public static BlockState getRandomWool() {
        return wools[rand.nextInt(wools.length)].defaultBlockState();
    }

    public static boolean isPlayerOnline(Player player) {
        if (player == null) {
            return false;
        }
        for (ServerPlayer playerMP : player.level().getServer().getPlayerList().getPlayers()) {
            if (!playerMP.getUUID().equals(player.getUUID())) continue;
            return true;
        }
        return false;
    }

    public static void executeCommand(ServerLevel level, Player player, Vec3i pos, String command) {
        RewardsUtil.executeCommand(level, player, new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()), command);
    }

    public static void executeCommand(ServerLevel level, Player player, Vec3 pos, String command) {
        MinecraftServer server = level.getServer();
        boolean rule = level.getGameRules().getBoolean(GameRules.RULE_COMMANDBLOCKOUTPUT);
        ((GameRules.BooleanValue)level.getGameRules().getRule(GameRules.RULE_COMMANDBLOCKOUTPUT)).set(false, server);
        CommandSourceStack cs = new CommandSourceStack((CommandSource)player, pos, player.getRotationVector(), level, 2, player.getName().getString(), player.getDisplayName(), server, (Entity)player);
        cs = cs.withSuppressedOutput();
        server.getCommands().performPrefixedCommand(cs, command);
        ((GameRules.BooleanValue)level.getGameRules().getRule(GameRules.RULE_COMMANDBLOCKOUTPUT)).set(rule, server);
    }

    public static void setNearPlayersTitle(Level level, BlockPos pos, int range, GuiTextLocation type, Component message, int fadeInTime, int displayTime, int fadeOutTime) {
        for (int i = 0; i < level.players().size(); ++i) {
            Player entityplayer = (Player)level.players().get(i);
            double dist = Math.sqrt(Math.pow((double)pos.getX() - entityplayer.getX(), 2.0) + Math.pow((double)pos.getY() - entityplayer.getY(), 2.0) + Math.pow((double)pos.getZ() - entityplayer.getZ(), 2.0));
            if (!(dist <= (double)range)) continue;
            RewardsUtil.setPlayerTitle(entityplayer, type, message, fadeInTime, displayTime, fadeOutTime);
        }
    }

    public static void setAllPlayersTitle(Level level, GuiTextLocation type, Component message, int fadeInTime, int displayTime, int fadeOutTime) {
        for (int i = 0; i < level.players().size(); ++i) {
            RewardsUtil.setPlayerTitle((Player)level.players().get(i), type, message, fadeInTime, displayTime, fadeOutTime);
        }
    }

    public static void setPlayerTitle(Player player, GuiTextLocation type, Component message, int fadeInTime, int displayTime, int fadeOutTime) {
        if (player instanceof ServerPlayer) {
            ClientboundSetTitleTextPacket titlePacket = switch (type) {
                case GuiTextLocation.TITLE -> new ClientboundSetTitleTextPacket(message);
                case GuiTextLocation.SUBTITLE -> new ClientboundSetSubtitleTextPacket(message);
                default -> new ClientboundSetActionBarTextPacket(message);
            };
            ClientboundSetTitlesAnimationPacket timesPacket = new ClientboundSetTitlesAnimationPacket(fadeInTime, displayTime, fadeOutTime);
            ((ServerPlayer)player).connection.send((Packet)timesPacket);
            ((ServerPlayer)player).connection.send((Packet)titlePacket);
        }
    }

    public static String[] getHardcodedRewards() {
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(RewardsUtil.class.getResourceAsStream("/data/chancecubes/rewards/rewards.txt")));
            ArrayList<String> files = new ArrayList<String>();
            while ((line = in.readLine()) != null) {
                files.add(line);
            }
            in.close();
            return files.toArray(new String[0]);
        }
        catch (Exception e) {
            CCubesCore.logger.error("CHANCE CUBES WAS UNABLE TO LOAD IN ITS DEFAULT REWARDS!!!!");
            CCubesCore.logger.error("REPORT TO MOD AUTHOR ASAP!!!");
            e.printStackTrace();
            return new String[0];
        }
    }

    public static JsonObject getRewardJson(String file) {
        BufferedReader in = new BufferedReader(new InputStreamReader(RewardsUtil.class.getResourceAsStream("/data/chancecubes/rewards/" + file)));
        StringBuilder builder = new StringBuilder();
        try {
            String line;
            while ((line = in.readLine()) != null) {
                builder.append(line);
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return JsonParser.parseString((String)builder.toString()).getAsJsonObject();
    }
}

