/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.util;

import chanceCubes.config.CCubesSettings;
import chanceCubes.mcwrapper.BlockWrapper;
import chanceCubes.util.RewardsUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class RewardBlockCache {
    protected final List<StoredBlockData> storedBlocks = new ArrayList<StoredBlockData>();
    protected final Map<BlockPos, CompoundTag> storedTE = new HashMap<BlockPos, CompoundTag>();
    private final BlockPos origin;
    private final BlockPos playerLoc;
    private final Level level;
    private boolean force = true;

    public RewardBlockCache(Level level, BlockPos pos, BlockPos playerLoc) {
        this.level = level;
        this.origin = pos;
        this.playerLoc = playerLoc;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void cacheBlock(BlockPos offset, BlockState newState) {
        this.cacheBlock(offset, newState, 3);
    }

    public void cacheBlock(BlockPos offset, BlockState newState, int update) {
        BlockPos adjPos = this.origin.offset((Vec3i)offset);
        BlockState oldState = this.level.getBlockState(adjPos);
        CompoundTag oldNBT = null;
        BlockEntity te = this.level.getBlockEntity(adjPos);
        if (te != null) {
            oldNBT = te.saveWithoutMetadata((HolderLookup.Provider)this.level.registryAccess());
            if (te instanceof Container) {
                ((Container)te).clearContent();
            }
        }
        if (RewardsUtil.placeBlock(newState, this.level, adjPos, update, this.force) && this.storedBlocks.stream().noneMatch(t -> t.pos.equals((Object)offset))) {
            this.storedBlocks.add(new StoredBlockData(offset, oldState, newState));
            if (oldNBT != null) {
                this.storedTE.put(offset, oldNBT);
            }
        }
    }

    public void restoreBlocks(Entity player) {
        List blockedRestoreBlocks = (List)CCubesSettings.blockRestoreBlacklist.get();
        for (StoredBlockData storedBlock : this.storedBlocks) {
            BlockPos worldPos = this.origin.offset((Vec3i)storedBlock.pos);
            ResourceLocation res = BlockWrapper.getBlockId(this.level.getBlockState(worldPos).getBlock());
            if (res != null && blockedRestoreBlocks.contains(res.toString())) continue;
            RewardsUtil.placeBlock(storedBlock.oldState, this.level, worldPos, true);
            BlockEntity tile = this.level.getBlockEntity(worldPos);
            if (!this.storedTE.containsKey(storedBlock.pos) || tile == null) continue;
            tile.loadWithComponents(this.storedTE.get(storedBlock.pos), (HolderLookup.Provider)this.level.registryAccess());
        }
        if (player != null) {
            player.moveTo((double)this.playerLoc.getX() + 0.5, (double)(this.playerLoc.getY() + 1), (double)this.playerLoc.getZ() + 0.5);
        }
    }

    private static class StoredBlockData {
        public final BlockPos pos;
        public final BlockState oldState;
        public final BlockState placedState;

        public StoredBlockData(BlockPos pos, BlockState oldState, BlockState placedState) {
            this.pos = pos;
            this.oldState = oldState;
            this.placedState = placedState;
        }
    }
}

