/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.tileentities;

import chanceCubes.blocks.CCubesBlocks;
import chanceCubes.config.CCubesSettings;
import chanceCubes.registry.global.GlobalCCRewardRegistry;
import chanceCubes.sounds.CCubesSounds;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Quaternionf;

public class TileChanceD20
extends BlockEntity {
    private static final Random random = new Random();
    private boolean breaking = false;
    private int stage = 0;
    public float rotation = 0.0f;
    public float wave = 0.0f;
    private Player player;
    private int chance;
    private boolean isScanned = false;

    public TileChanceD20(BlockPos pos, BlockState state) {
        super((BlockEntityType)CCubesBlocks.TILE_CHANCE_ICOSAHEDRON.get(), pos, state);
        if (!((Boolean)CCubesSettings.d20UseNormalChances.get()).booleanValue()) {
            this.chance = random.nextBoolean() ? -100 : 100;
        } else {
            this.chance = Math.round((float)(random.nextGaussian() * 40.0));
            while (this.chance > 100 || this.chance < -100) {
                this.chance = Math.round((float)(random.nextGaussian() * 40.0));
            }
        }
    }

    public TileChanceD20(int initialChance, BlockPos pos, BlockState state) {
        super((BlockEntityType)CCubesBlocks.TILE_CHANCE_ICOSAHEDRON.get(), pos, state);
        this.chance = initialChance;
    }

    public void setChance(int newChance) {
        this.chance = newChance;
    }

    public int getChance() {
        return this.chance;
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        nbt.putInt("chance", this.getChance());
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag nbt = new CompoundTag();
        this.saveAdditional(nbt, registries);
        return nbt;
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.chance = nbt.getInt("chance");
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos blockPos, BlockState blockState, T t) {
        TileChanceD20 d20 = (TileChanceD20)t;
        if (d20.breaking && d20.stage < 200) {
            ++d20.stage;
        }
        if (d20.stage >= 200) {
            d20.breaking = false;
            d20.stage = 0;
            if (level != null && !level.isClientSide()) {
                level.setBlockAndUpdate(blockPos, Blocks.AIR.defaultBlockState());
                level.removeBlockEntity(blockPos);
                GlobalCCRewardRegistry.DEFAULT.triggerRandomReward((ServerLevel)level, blockPos, d20.player, d20.getChance());
            }
        } else if (level != null && level.isClientSide()) {
            Quaternionf yaw = new Quaternionf(0.0f, 1.0f, 0.0f, (float)(Math.toRadians((float)level.getGameTime() % 10000.0f / 10000.0f * 360.0f) + (0.4 + Math.pow(1.02, d20.getStage() + 1))));
            Quaternionf pitch = new Quaternionf(1.0f, 0.0f, 0.0f, 0.0f);
            level.setBlockAndUpdate(blockPos, blockState);
        }
    }

    public void startBreaking(Player player) {
        if (!this.breaking) {
            if (!player.level().isClientSide()) {
                player.level().playSound(null, (double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ(), (SoundEvent)CCubesSounds.D20_BREAK.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                this.player = player;
            }
            this.breaking = true;
            this.stage = 0;
        }
    }

    public int getStage() {
        return this.stage;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider registries) {
        this.loadAdditional(pkt.getTag(), registries);
    }

    public boolean isScanned() {
        return this.isScanned;
    }

    public void setScanned(boolean isScanned) {
        this.isScanned = isScanned;
    }
}

