/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.rewardtype;

import chanceCubes.rewards.rewardparts.TitlePart;
import chanceCubes.rewards.rewardtype.BaseRewardType;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class TitleRewardType
extends BaseRewardType<TitlePart> {
    public TitleRewardType(TitlePart ... effects) {
        super(effects);
    }

    @Override
    public void trigger(final TitlePart part, final ServerLevel level, final int x, final int y, final int z, final Player player) {
        Scheduler.scheduleTask(new Task(this, "Title Delay", part.getDelay()){

            @Override
            public void callback() {
                for (int i = 0; i < level.players().size(); ++i) {
                    ServerPlayer entityPlayer = (ServerPlayer)level.players().get(i);
                    if (entityPlayer.equals((Object)player)) {
                        RewardsUtil.setPlayerTitle(player, part.getType(), part.getMessage(), part.getFadeInTime(), part.getDisplayTime(), part.getFadeOutTime());
                        continue;
                    }
                    double dist = Math.sqrt(Math.pow((double)x - entityPlayer.getX(), 2.0) + Math.pow((double)y - entityPlayer.getY(), 2.0) + Math.pow((double)z - entityPlayer.getZ(), 2.0));
                    if (!(dist <= (double)part.getRange()) && !part.isServerWide()) continue;
                    RewardsUtil.setPlayerTitle(player, part.getType(), part.getMessage(), part.getFadeInTime(), part.getDisplayTime(), part.getFadeOutTime());
                }
            }
        });
    }
}

