/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.giantRewards;

import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.rewards.rewardparts.OffsetBlock;
import chanceCubes.util.RewardsUtil;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class BlockInfectionReward
extends BaseCustomReward {
    private final BlockState[] whitelist = new BlockState[]{Blocks.OBSIDIAN.defaultBlockState(), Blocks.DIRT.defaultBlockState(), Blocks.STONE.defaultBlockState(), Blocks.MELON.defaultBlockState(), Blocks.BOOKSHELF.defaultBlockState(), Blocks.CLAY.defaultBlockState(), RewardsUtil.getRandomWool(), Blocks.BRICKS.defaultBlockState(), Blocks.COBWEB.defaultBlockState(), Blocks.GLOWSTONE.defaultBlockState(), Blocks.NETHERRACK.defaultBlockState()};
    private final BlockPos[] touchingPos = new BlockPos[]{new BlockPos(1, 0, 0), new BlockPos(0, 0, 1), new BlockPos(0, 1, 0), new BlockPos(-1, 0, 0), new BlockPos(0, 0, -1), new BlockPos(0, -1, 0)};

    public BlockInfectionReward() {
        super("chancecubes:world_infection", 0);
    }

    @Override
    public void trigger(ServerLevel level, BlockPos pos, Player player, JsonObject settings) {
        int delay = 0;
        int delayShorten = 20;
        BlockPos lastPos = pos;
        ArrayList<BlockPos> possibleBlocks = new ArrayList<BlockPos>();
        ArrayList<BlockPos> changedBlocks = new ArrayList<BlockPos>();
        changedBlocks.add(new BlockPos(0, 0, 0));
        ArrayList<OffsetBlock> blocks = new ArrayList<OffsetBlock>();
        this.addSurroundingBlocks((Level)level, pos, new BlockPos(0, 0, 0), changedBlocks, possibleBlocks);
        for (int i = 0; i < 5000; ++i) {
            BlockPos nextPos;
            if (possibleBlocks.size() > 0) {
                int index = RewardsUtil.rand.nextInt(possibleBlocks.size());
                nextPos = (BlockPos)possibleBlocks.get(index);
                possibleBlocks.remove(index);
            } else {
                nextPos = lastPos.offset((Vec3i)this.touchingPos[RewardsUtil.rand.nextInt(this.touchingPos.length)]);
            }
            changedBlocks.add(nextPos);
            this.addSurroundingBlocks((Level)level, pos, nextPos, changedBlocks, possibleBlocks);
            BlockState state = this.whitelist[RewardsUtil.rand.nextInt(this.whitelist.length)];
            blocks.add(new OffsetBlock(nextPos.getX(), nextPos.getY(), nextPos.getZ(), state, false, delay / delayShorten));
            ++delay;
            lastPos = nextPos;
        }
        for (OffsetBlock b : blocks) {
            b.spawnInWorld((Level)level, pos.getX(), pos.getY(), pos.getZ());
        }
    }

    private void addSurroundingBlocks(Level level, BlockPos worldCord, BlockPos offsetCord, List<BlockPos> changedBlocks, List<BlockPos> possibleBlocks) {
        for (BlockPos pos : this.touchingPos) {
            BlockPos checkPos = offsetCord.offset((Vec3i)pos);
            if (changedBlocks.contains(checkPos) || possibleBlocks.contains(checkPos) || level.getBlockState(worldCord.offset((Vec3i)checkPos)).getBlock() instanceof AirBlock) continue;
            possibleBlocks.add(checkPos);
        }
    }
}

