/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.util.RewardBlockCache;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import com.google.gson.JsonObject;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class MontyHallReward
extends BaseCustomReward {
    public MontyHallReward() {
        super("chancecubes:monty_hall", 0);
    }

    @Override
    public void trigger(final ServerLevel level, final BlockPos pos, final Player player, JsonObject settings) {
        RewardsUtil.sendMessageToPlayer(player, "Which button do you press?");
        final RewardBlockCache cache = new RewardBlockCache((Level)level, pos, player.getOnPos());
        cache.cacheBlock(new BlockPos(-1, 0, 0), Blocks.OBSIDIAN.defaultBlockState());
        cache.cacheBlock(new BlockPos(0, 0, 0), Blocks.OBSIDIAN.defaultBlockState());
        cache.cacheBlock(new BlockPos(1, 0, 0), Blocks.OBSIDIAN.defaultBlockState());
        cache.cacheBlock(new BlockPos(-1, 0, 1), (BlockState)Blocks.STONE_BUTTON.defaultBlockState().setValue((Property)ButtonBlock.FACING, (Comparable)Direction.SOUTH));
        cache.cacheBlock(new BlockPos(0, 0, 1), (BlockState)Blocks.STONE_BUTTON.defaultBlockState().setValue((Property)ButtonBlock.FACING, (Comparable)Direction.SOUTH));
        cache.cacheBlock(new BlockPos(1, 0, 1), (BlockState)Blocks.STONE_BUTTON.defaultBlockState().setValue((Property)ButtonBlock.FACING, (Comparable)Direction.SOUTH));
        Scheduler.scheduleTask(new Task(this, "Monty_Hall_Reward", 6000, 10){
            final int[] chance;
            {
                super(name, delay, updateTick);
                this.chance = new int[]{RewardsUtil.rand.nextInt(3) - 1, RewardsUtil.rand.nextInt(3) - 1, RewardsUtil.rand.nextInt(3) - 1};
            }

            @Override
            public void callback() {
                cache.restoreBlocks((Entity)player);
            }

            @Override
            public void update() {
                BlockState state = level.getBlockState(pos.offset(-1, 0, 1));
                if (state.getProperties().contains(ButtonBlock.POWERED) && ((Boolean)state.getValue((Property)ButtonBlock.POWERED)).booleanValue()) {
                    this.giveReward(this.chance[0]);
                }
                if ((state = level.getBlockState(pos.offset(0, 0, 1))).getProperties().contains(ButtonBlock.POWERED) && ((Boolean)state.getValue((Property)ButtonBlock.POWERED)).booleanValue()) {
                    this.giveReward(this.chance[1]);
                }
                if ((state = level.getBlockState(pos.offset(1, 0, 1))).getProperties().contains(ButtonBlock.POWERED) && ((Boolean)state.getValue((Property)ButtonBlock.POWERED)).booleanValue()) {
                    this.giveReward(this.chance[2]);
                }
            }

            private void giveReward(int value) {
                if (value == -1) {
                    PrimedTnt entitytntprimed = new PrimedTnt((Level)level, player.getX(), player.getY() + 1.0, player.getZ(), (LivingEntity)player);
                    level.addFreshEntity((Entity)entitytntprimed);
                    level.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.TNT_PRIMED, SoundSource.BLOCKS, 1.0f, 1.0f);
                    entitytntprimed.setFuse(40);
                } else if (value == 0) {
                    RewardsUtil.sendMessageToPlayer(player, "You walk away to live another day...");
                } else if (value == 1) {
                    player.level().addFreshEntity((Entity)new ItemEntity(player.level(), player.getX(), player.getY(), player.getZ(), new ItemStack((ItemLike)RewardsUtil.getRandomItem(), 1)));
                }
                this.callback();
                Scheduler.removeTask(this);
            }
        });
    }
}

