/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.util.CCubesDamageTypes;
import chanceCubes.util.GuiTextLocation;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import com.google.gson.JsonObject;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class DigBuildReward
extends BaseCustomReward {
    public DigBuildReward() {
        super("chancecubes:dig_build", -5);
    }

    @Override
    public void trigger(ServerLevel world, BlockPos pos, final Player player, JsonObject settings) {
        int distance;
        int initalY;
        int max;
        int min = super.getSettingAsInt(settings, "min", 5, 0, 100);
        if (min > (max = super.getSettingAsInt(settings, "max", 25, 0, 100))) {
            int swap = min;
            min = max;
            max = swap;
        }
        final boolean up = (initalY = player.getOnPos().getY()) + (distance = RewardsUtil.rand.nextInt(max - min) + min) <= 150 && (initalY - distance < 2 || RewardsUtil.rand.nextBoolean());
        RewardsUtil.sendMessageToPlayer(player, "Quick! Go " + (up ? "up " : "down ") + distance + " blocks!");
        RewardsUtil.sendMessageToPlayer(player, "You have " + (distance + 3) + " seconds!");
        Scheduler.scheduleTask(new Task(this, "Dig_Build_Reward_Delay", (distance + 3) * 20, 5){

            @Override
            public void callback() {
                player.level().explode((Entity)player, player.getX(), player.getY(), player.getZ(), 1.0f, Level.ExplosionInteraction.NONE);
                player.hurt(player.damageSources().source(CCubesDamageTypes.DIG_BUILD_FAIL), Float.MAX_VALUE);
            }

            @Override
            public void update() {
                if (up && player.getOnPos().getY() >= initalY + distance) {
                    RewardsUtil.sendMessageToPlayer(player, "Good Job!");
                    RewardsUtil.sendMessageToPlayer(player, "Here, have a item!");
                    player.level().addFreshEntity((Entity)new ItemEntity(player.level(), player.getX(), player.getY(), player.getZ(), new ItemStack((ItemLike)RewardsUtil.getRandomItem(), 1)));
                    Scheduler.removeTask(this);
                } else if (!up && player.getOnPos().getY() <= initalY - distance) {
                    RewardsUtil.sendMessageToPlayer(player, "Good Job!");
                    RewardsUtil.sendMessageToPlayer(player, "Here, have a item!");
                    player.level().addFreshEntity((Entity)new ItemEntity(player.level(), player.getX(), player.getY(), player.getZ(), new ItemStack((ItemLike)RewardsUtil.getRandomItem(), 1)));
                    Scheduler.removeTask(this);
                }
                if (this.delayLeft % 20 == 0) {
                    this.showTimeLeft(player, GuiTextLocation.ACTION_BAR);
                }
            }
        });
    }
}

