/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.biodomeGen;

import chanceCubes.rewards.biodomeGen.BaseBiome;
import chanceCubes.rewards.rewardparts.OffsetBlock;
import chanceCubes.util.RewardsUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class NetherBiome
extends BaseBiome {
    public NetherBiome(String name) {
        super(name);
    }

    @Override
    public void spawnEntities(BlockPos center, ServerLevel world) {
        Random rand = RewardsUtil.rand;
        for (int i = 0; i < rand.nextInt(10) + 5; ++i) {
            int ri = rand.nextInt(5);
            if (ri == 0) {
                Ghast ghast = (Ghast)EntityType.GHAST.create((Level)world);
                ghast.moveTo((double)(center.getX() + (rand.nextInt(31) - 15)), (double)(center.getY() + 5), (double)(center.getZ() + (rand.nextInt(31) - 15)), 0.0f, 0.0f);
                world.addFreshEntity((Entity)ghast);
                continue;
            }
            ZombifiedPiglin pigman = (ZombifiedPiglin)EntityType.ZOMBIFIED_PIGLIN.create((Level)world);
            pigman.moveTo((double)(center.getX() + (rand.nextInt(31) - 15)), (double)(center.getY() + 1), (double)(center.getZ() + (rand.nextInt(31) - 15)), 0.0f, 0.0f);
            world.addFreshEntity((Entity)pigman);
        }
    }

    @Override
    public Block getFloorBlock() {
        return Blocks.NETHERRACK;
    }

    @Override
    public void getRandomGenBlock(float dist, Random rand, int x, int y, int z, List<OffsetBlock> blocks, int delay) {
        if (y != 0) {
            return;
        }
        if (dist < 0.0f && rand.nextInt(50) == 0) {
            OffsetBlock osb = new OffsetBlock(x, y - 1, z, Blocks.NETHERRACK, false, delay / 10);
            blocks.add(osb);
            osb = new OffsetBlock(x, y, z, Blocks.LAVA, false, ++delay / 10 + 1);
            blocks.add(osb);
        } else if (dist < 0.0f && rand.nextInt(20) == 0) {
            OffsetBlock osb = new OffsetBlock(x, y, z, Blocks.SOUL_SAND, false, delay / 10 + 1);
            blocks.add(osb);
        }
    }
}

