/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.client;

import chanceCubes.blocks.CCubesBlocks;
import chanceCubes.client.gui.CreativePendantScreen;
import chanceCubes.client.gui.RewardSelectorPendantScreen;
import chanceCubes.client.gui.SchematicCreationGui;
import chanceCubes.client.listeners.RenderEvent;
import chanceCubes.client.listeners.WorldRenderListener;
import chanceCubes.commands.CCubesClientCommands;
import chanceCubes.containers.CCubesMenus;
import chanceCubes.containers.CreativePendantContainer;
import chanceCubes.listeners.BlockListener;
import chanceCubes.renderer.TileChanceD20Renderer;
import chanceCubes.renderer.TileCubeDispenserRenderer;
import chanceCubes.renderer.TileGiantCubeRenderer;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;

public class ClientHelper {
    @SubscribeEvent
    public static void clientStart(FMLClientSetupEvent event) {
        NeoForge.EVENT_BUS.register((Object)new RenderEvent());
        NeoForge.EVENT_BUS.register((Object)new WorldRenderListener());
        NeoForge.EVENT_BUS.register((Object)new BlockListener());
    }

    @SubscribeEvent
    public static void onEntityRenders(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)CCubesBlocks.TILE_CHANCE_ICOSAHEDRON.get(), TileChanceD20Renderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)CCubesBlocks.TILE_CUBE_DISPENSER.get(), TileCubeDispenserRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)CCubesBlocks.TILE_CHANCE_GIANT.get(), TileGiantCubeRenderer::new);
    }

    @SubscribeEvent
    public static void registerMenuScreens(RegisterMenuScreensEvent event) {
        event.register((MenuType)CCubesMenus.CREATIVE_PENDANT_CONTAINER.get(), CreativePendantScreen::new);
    }

    public static void onClientCommandsRegister(RegisterClientCommandsEvent event) {
        new CCubesClientCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public static void openRewardSelectorGUI(Player player, ItemStack stack) {
        Minecraft.getInstance().setScreen((Screen)new RewardSelectorPendantScreen(player, stack));
    }

    public static void openCreativePendantGUI(Player player, ItemStack stack) {
        player.openMenu((MenuProvider)new SimpleMenuProvider((w, p, pl) -> new CreativePendantContainer(w, p), stack.getHoverName()));
    }

    public static void openSchematicCreatorGUI(Player player) {
        Minecraft.getInstance().setScreen((Screen)new SchematicCreationGui(player));
    }

    public static <T extends CustomPacketPayload> void sendToServer(T packet) {
        PacketDistributor.sendToServer(packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

