/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.networking.minecraft;

import carbonconfiglib.CarbonConfig;
import carbonconfiglib.networking.ICarbonPacket;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicLike;
import com.mojang.serialization.DynamicOps;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class SaveGameRulesPacket
implements ICarbonPacket {
    public static final StreamCodec<FriendlyByteBuf, SaveGameRulesPacket> STREAM_CODEC = CustomPacketPayload.codec(SaveGameRulesPacket::write, ICarbonPacket.readPacket(SaveGameRulesPacket::new));
    public static final CustomPacketPayload.Type<SaveGameRulesPacket> ID = ICarbonPacket.createType("carbonconfig:save_mc");
    GameRules rules;

    public SaveGameRulesPacket(GameRules rules) {
        this.rules = rules;
    }

    public SaveGameRulesPacket(FriendlyByteBuf buffer) {
        this.rules = new GameRules((DynamicLike)new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)buffer.readNbt()));
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeNbt((Tag)this.rules.createTag());
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    @Override
    public void process(Player player) {
        if (!CarbonConfig.hasPermission(player, 4)) {
            CarbonConfig.LOGGER.warn("Don't have Permission to Change configs");
            return;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return;
        }
        server.getGameRules().assignFrom(this.rules, server);
    }
}

