/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.impl.carbon;

import carbonconfiglib.api.IReloadMode;
import carbonconfiglib.config.ConfigEntry;
import carbonconfiglib.gui.api.DataType;
import carbonconfiglib.gui.api.IConfigNode;
import carbonconfiglib.gui.api.INode;
import carbonconfiglib.gui.impl.carbon.CarbonArray;
import carbonconfiglib.gui.impl.carbon.CarbonCompound;
import carbonconfiglib.gui.impl.carbon.CarbonValue;
import carbonconfiglib.gui.impl.carbon.IValueActions;
import carbonconfiglib.impl.ReloadMode;
import carbonconfiglib.utils.Helpers;
import carbonconfiglib.utils.structure.IStructuredData;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.apache.logging.log4j.util.Strings;

public class ConfigLeaf
implements IConfigNode {
    ConfigEntry<?> entry;
    IStructuredData data;
    IStructuredData.StructureType type;
    IReloadMode mode;
    IValueActions value;

    public ConfigLeaf(ConfigEntry<?> entry) {
        this.entry = entry;
        this.data = entry.getDataType();
        this.type = this.data.getDataType();
        this.mode = entry.getReloadState();
    }

    @Override
    public INode asNode() {
        if (this.value == null) {
            switch (this.type) {
                case COMPOUND: {
                    this.value = new CarbonCompound(this.mode, this.data.asCompound(), this.getName(), this.getTooltip(), this.entry.serialize(), this.entry.serializeDefault(), this.entry::canSetValue, () -> this.entry.getSuggestions(T -> true), this::save);
                    break;
                }
                case LIST: {
                    this.value = new CarbonArray(this.mode, this.data.asList(), this.getName(), this.getTooltip(), this.entry.serialize(), this.entry.serializeDefault(), this.entry::canSetValue, () -> this.entry.getSuggestions(T -> true), this::save);
                    break;
                }
                case SIMPLE: {
                    this.value = new CarbonValue(this.mode, this.getName(), this.getTooltip(), this.entry.getSettings(), DataType.bySimple(this.entry.getDataType().asSimple()), this.entry.areSuggestionsForced(), () -> this.entry.getSuggestions(T -> true), this.entry.serialize(), this.entry.serializeDefault(), this.entry::canSetValue, this::save);
                }
            }
        }
        return this.value;
    }

    private void save(String value, IValueActions actions) {
        if (this.entry instanceof ConfigEntry.ParsedArray) {
            this.entry.deserializeValue(Helpers.removeLayer(value, 0));
            return;
        }
        this.entry.deserializeValue(value);
    }

    @Override
    public List<IConfigNode> getChildren() {
        return null;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    @Override
    public boolean isChanged() {
        return this.value != null && this.value.isChanged();
    }

    @Override
    public void setPrevious() {
        if (this.value != null) {
            this.value.setPrevious();
        }
    }

    @Override
    public void setDefault() {
        if (this.value != null) {
            this.value.setDefault();
        }
    }

    @Override
    public void save() {
        if (this.value != null) {
            this.value.save();
        }
    }

    @Override
    public boolean requiresRestart() {
        return this.mode == ReloadMode.GAME;
    }

    @Override
    public boolean requiresReload() {
        return this.mode == ReloadMode.WORLD;
    }

    @Override
    public String getNodeName() {
        return null;
    }

    @Override
    public Component getName() {
        return IConfigNode.createLabel(this.entry.getKey(), this.entry.getTranslationKey());
    }

    @Override
    public Component getTooltip() {
        MutableComponent comp = Component.empty();
        String key = this.entry.getTranslationKey();
        comp.append((Component)(key != null && I18n.exists((String)key) ? Component.translatable((String)key) : Component.literal((String)this.entry.getKey())).withStyle(ChatFormatting.YELLOW));
        key = this.entry.getTranslationComment();
        if (key != null && I18n.exists((String)key)) {
            comp.append("\n").append((Component)Component.translatable((String)key).withStyle(ChatFormatting.GRAY));
        } else {
            String[] array = this.entry.getComment();
            if (array != null && array.length > 0) {
                int i = 0;
                while (i < array.length) {
                    comp.append("\n").append(array[i++]).withStyle(ChatFormatting.GRAY);
                }
            }
        }
        String limit = this.entry.getLimitations();
        if (!Strings.isBlank((String)limit)) {
            comp.append("\n").append((Component)Component.literal((String)limit).withStyle(ChatFormatting.BLUE));
        }
        return comp;
    }

    @Override
    public IStructuredData.StructureType getDataStructure() {
        return this.type;
    }
}

