/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.config;

import carbonconfiglib.gui.api.BackgroundTexture;
import carbonconfiglib.gui.config.Element;
import carbonconfiglib.gui.screen.SmoothFloat;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ElementList
extends ContainerObjectSelectionList<Element> {
    BackgroundTexture.BackgroundHolder customBackground;
    int listWidth = 220;
    int scrollPadding = 124;
    int endY;
    Consumer<Element> callback;
    int lastTick = 0;
    boolean isScrolling;
    SmoothFloat value = new SmoothFloat(0.8f);
    boolean shouldSelect = false;

    public ElementList(int width, int height, int screenY, int endY, int itemHeight) {
        super(Minecraft.getInstance(), width, height, screenY, itemHeight);
        this.endY = endY;
    }

    protected boolean isSelectedItem(int index) {
        return this.shouldSelect && Objects.equals(this.getSelected(), this.children().get(index));
    }

    public void setShouldSelectEntry(boolean value) {
        this.shouldSelect = value;
    }

    public void setCallback(Consumer<Element> callback) {
        this.callback = callback;
    }

    public void addElement(Element element) {
        this.addEntry((AbstractSelectionList.Entry)element);
    }

    public void addElements(List<Element> elements) {
        elements.forEach(x$0 -> this.addEntry((AbstractSelectionList.Entry)x$0));
    }

    public void updateList(List<Element> elements) {
        super.replaceEntries(elements);
    }

    public void removeElement(Element element) {
        this.removeEntry((AbstractSelectionList.Entry)element);
    }

    public int size() {
        return this.children().size();
    }

    public void setSelected(Element p_93462_) {
        super.setSelected((AbstractSelectionList.Entry)p_93462_);
        if (this.callback != null && this.getSelected() != null) {
            this.callback.accept((Element)this.getSelected());
        }
    }

    public void scrollToElement(Element element, boolean center) {
        int index = this.children().indexOf((Object)element);
        if (index == -1) {
            return;
        }
        this.scrollToElement(index, center);
    }

    public void scrollToSelected(boolean center) {
        if (this.getSelected() == null) {
            return;
        }
        this.scrollToElement((Element)this.getSelected(), center);
    }

    public void scrollToElement(int index, boolean center) {
        if (center) {
            index -= this.height / this.itemHeight / 3;
        }
        this.setScrollAmount(Math.max(0, index) * this.itemHeight + this.headerHeight);
    }

    public void setListWidth(int listWidth) {
        this.listWidth = listWidth;
    }

    public void setScrollPadding(int scrollPadding) {
        this.scrollPadding = scrollPadding;
    }

    public int getRowWidth() {
        return this.listWidth;
    }

    public int getLastTick() {
        return this.lastTick;
    }

    protected int getScrollbarPosition() {
        return this.width / 2 + this.scrollPadding;
    }

    protected void updateScrollingState(double mouseX, double mouseY, int button) {
        this.isScrolling = button == 0 && mouseX >= (double)this.getScrollbarPosition() && mouseX < (double)(this.getScrollbarPosition() + 6);
        super.updateScrollingState(mouseX, mouseY, button);
    }

    public void setScrollAmount(double value) {
        this.setScrollAmount(value, this.isScrolling);
    }

    public void setScrollAmount(double value, boolean force) {
        float actualValue = (float)Mth.clamp((double)value, (double)0.0, (double)this.getMaxScroll());
        this.value.setTarget(actualValue);
        if (force) {
            this.value.forceFinish();
        }
    }

    public double getScrollAmount() {
        return this.isScrolling ? (double)this.value.getTarget() : (double)this.value.getValue();
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.isScrolling = false;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double otherScroll, double scroll) {
        this.setScrollAmount(this.getScrollAmount() - scroll * (double)this.itemHeight * 2.0);
        return true;
    }

    public void tick() {
        ++this.lastTick;
        int max = this.getItemCount();
        for (int i = 0; i < max; ++i) {
            int j1 = this.getRowTop(i);
            if (j1 + this.itemHeight < this.getY() || j1 > this.getBottom()) continue;
            ((Element)this.getEntry(i)).tick();
        }
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.value.update(partialTicks);
        super.setScrollAmount((double)this.value.getValue());
        super.renderWidget(graphics, mouseX, mouseY, partialTicks);
    }

    public void setCustomBackground(BackgroundTexture.BackgroundHolder customBackground) {
        this.customBackground = customBackground;
    }

    protected void renderListBackground(GuiGraphics graphics) {
        if (this.customBackground != null) {
            if (this.minecraft.level == null || !this.customBackground.shouldDisableInLevel()) {
                ElementList.renderBackground(this.getX(), this.getRight(), this.getY(), this.getBottom(), (float)this.getScrollAmount(), this.customBackground.getTexture());
            }
            return;
        }
        super.renderListBackground(graphics);
    }

    protected void renderDecorations(GuiGraphics graphics, int mouseX, int mouseY) {
        if (this.customBackground == null) {
            return;
        }
        ElementList.renderListOverlay(this.getX(), this.getRight(), this.getY(), this.getBottom(), this.width, this.endY, this.customBackground.getTexture());
    }

    public static void renderListOverlay(int x0, int x1, int y0, int y1, int width, int endY, BackgroundTexture texture) {
        Tesselator tes = Tesselator.getInstance();
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture.getForegroundTexture());
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)519);
        int color = texture.getForegroundBrightness();
        BufferBuilder builder = tes.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        builder.addVertex((float)x0, (float)y0, -100.0f).setUv(0.0f, (float)y0 / 32.0f).setColor(color, color, color, 255);
        builder.addVertex((float)(x0 + width), (float)y0, -100.0f).setUv((float)width / 32.0f, (float)y0 / 32.0f).setColor(color, color, color, 255);
        builder.addVertex((float)(x0 + width), 0.0f, -100.0f).setUv((float)width / 32.0f, 0.0f).setColor(color, color, color, 255);
        builder.addVertex((float)x0, 0.0f, -100.0f).setUv(0.0f, 0.0f).setColor(color, color, color, 255);
        builder.addVertex((float)x0, (float)endY, -100.0f).setUv(0.0f, (float)endY / 32.0f).setColor(color, color, color, 255);
        builder.addVertex((float)(x0 + width), (float)endY, -100.0f).setUv((float)width / 32.0f, (float)endY / 32.0f).setColor(color, color, color, 255);
        builder.addVertex((float)(x0 + width), (float)y1, -100.0f).setUv((float)width / 32.0f, (float)y1 / 32.0f).setColor(color, color, color, 255);
        builder.addVertex((float)x0, (float)y1, -100.0f).setUv(0.0f, (float)y1 / 32.0f).setColor(color, color, color, 255);
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
        RenderSystem.depthFunc((int)515);
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        builder = tes.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        builder.addVertex((float)x0, (float)(y0 + 4), 0.0f).setColor(0, 0, 0, 0);
        builder.addVertex((float)x1, (float)(y0 + 4), 0.0f).setColor(0, 0, 0, 0);
        builder.addVertex((float)x1, (float)y0, 0.0f).setColor(0, 0, 0, 255);
        builder.addVertex((float)x0, (float)y0, 0.0f).setColor(0, 0, 0, 255);
        builder.addVertex((float)x0, (float)y1, 0.0f).setColor(0, 0, 0, 255);
        builder.addVertex((float)x1, (float)y1, 0.0f).setColor(0, 0, 0, 255);
        builder.addVertex((float)x1, (float)(y1 - 4), 0.0f).setColor(0, 0, 0, 0);
        builder.addVertex((float)x0, (float)(y1 - 4), 0.0f).setColor(0, 0, 0, 0);
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
    }

    public static void renderBackground(int x0, int x1, int y0, int y1, float scroll, BackgroundTexture texture) {
        Tesselator tes = Tesselator.getInstance();
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture.getBackgroundTexture());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int color = texture.getBackgroundBrightness();
        BufferBuilder builder = tes.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        builder.addVertex((float)x0, (float)y1, 0.0f).setUv((float)x0 / 32.0f, ((float)y1 + scroll) / 32.0f).setColor(color, color, color, 255);
        builder.addVertex((float)x1, (float)y1, 0.0f).setUv((float)x1 / 32.0f, ((float)y1 + scroll) / 32.0f).setColor(color, color, color, 255);
        builder.addVertex((float)x1, (float)y0, 0.0f).setUv((float)x1 / 32.0f, ((float)y0 + scroll) / 32.0f).setColor(color, color, color, 255);
        builder.addVertex((float)x0, (float)y0, 0.0f).setUv((float)x0 / 32.0f, ((float)y0 + scroll) / 32.0f).setColor(color, color, color, 255);
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
    }
}

