/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.objects.Object2BooleanLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.client.event.ModelEvent;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.jetbrains.annotations.NotNull;
import team.chisel.ctm.CTM;
import team.chisel.ctm.client.model.AbstractCTMBakedModel;
import team.chisel.ctm.client.model.ModelBakedCTM;
import team.chisel.ctm.client.model.ModelCTM;
import team.chisel.ctm.client.util.ResourceUtil;

public enum TextureMetadataHandler {
    INSTANCE;

    private final Object2BooleanMap<ModelResourceLocation> wrappedModels = new Object2BooleanLinkedOpenHashMap();
    private final Multimap<ResourceLocation, Material> scrapedTextures = HashMultimap.create();

    public void textureScraped(ResourceLocation modelLocation, Material material) {
        this.scrapedTextures.put((Object)modelLocation, (Object)material);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onModelBake(ModelEvent.ModifyBakingResult event) {
        ModelBakery modelBakery = event.getModelBakery();
        for (Map.Entry entry : event.getModels().entrySet()) {
            BakedModel baked;
            ModelResourceLocation mrl = (ModelResourceLocation)entry.getKey();
            UnbakedModel rootModel = (UnbakedModel)modelBakery.topLevelModels.get(mrl);
            if (rootModel == null || (baked = (BakedModel)entry.getValue()) instanceof AbstractCTMBakedModel || baked.isCustomRenderer()) continue;
            ArrayDeque<ResourceLocation> dependencies = new ArrayDeque<ResourceLocation>();
            HashSet<ResourceLocation> seenModels = new HashSet<ResourceLocation>();
            ResourceLocation rl = mrl.id();
            dependencies.push(rl);
            seenModels.add(rl);
            boolean shouldWrap = this.wrappedModels.getOrDefault((Object)mrl, false);
            while (!shouldWrap && !dependencies.isEmpty()) {
                UnbakedModel model;
                ResourceLocation dep = (ResourceLocation)dependencies.pop();
                try {
                    model = dep == rl ? rootModel : modelBakery.getModel(dep);
                }
                catch (Exception e) {
                    continue;
                }
                try {
                    HashSet textures = new HashSet(this.scrapedTextures.get((Object)dep));
                    for (Material tex : textures) {
                        try {
                            if (!ResourceUtil.getMetadata(ResourceUtil.spriteToAbsolute(tex.texture())).isPresent()) continue;
                            shouldWrap = true;
                            break;
                        }
                        catch (IOException iOException) {
                        }
                    }
                    if (shouldWrap) continue;
                    for (ResourceLocation newDep : model.getDependencies()) {
                        if (!seenModels.add(newDep)) continue;
                        dependencies.push(newDep);
                    }
                }
                catch (Exception e) {
                    CTM.logger.error((Message)new ParameterizedMessage("Error loading model dependency {} for model {}. Skipping...", (Object)dep, (Object)rl), (Throwable)e);
                }
            }
            this.wrappedModels.put((Object)mrl, shouldWrap);
            if (!shouldWrap) continue;
            try {
                entry.setValue(this.wrap(rootModel, baked));
            }
            catch (IOException e) {
                CTM.logger.error("Could not wrap model {}. Aborting...", (Object)rl, (Object)e);
            }
        }
    }

    @NotNull
    private BakedModel wrap(UnbakedModel model, BakedModel object) throws IOException {
        ModelCTM modelchisel = new ModelCTM(model);
        return new ModelBakedCTM(modelchisel, object, null);
    }

    @SubscribeEvent
    public void onModelBake(ModelEvent.BakingCompleted event) {
        Map cache = (Map)ObfuscationReflectionHelper.getPrivateValue(ModelBakery.class, (Object)event.getModelBakery(), (String)"bakedCache");
        Map cacheCopy = Map.copyOf(cache);
        cache.clear();
        for (Map.Entry e : event.getModels().entrySet()) {
            ModelCTM ctmModel;
            AbstractCTMBakedModel baked;
            Object object = e.getValue();
            if (!(object instanceof AbstractCTMBakedModel) || !((object = (baked = (AbstractCTMBakedModel)((Object)object)).getModel()) instanceof ModelCTM) || (ctmModel = (ModelCTM)object).isInitialized()) continue;
            ModelBakery.ModelBakerImpl baker = new ModelBakery.ModelBakerImpl(event.getModelBakery(), (rl, m) -> m.sprite(), (ModelResourceLocation)e.getKey());
            ctmModel.bake((ModelBaker)baker, Material::sprite, (ModelState)BlockModelRotation.X0_Y0);
            cache.clear();
        }
        cache.putAll(cacheCopy);
    }

    public void invalidateCaches() {
        this.wrappedModels.clear();
        this.scrapedTextures.clear();
    }
}

