/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class CommandTPX {
    private static Random rand = new Random();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tpx").requires(p_198816_0_ -> p_198816_0_.hasPermission(2))).then(((RequiredArgumentBuilder)Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).executes(ctx -> CommandTPX.teleportToPos((CommandSourceStack)ctx.getSource(), Collections.singleton(((CommandSourceStack)ctx.getSource()).getEntityOrException()), DimensionArgument.getDimension((CommandContext)ctx, (String)"dimension"), null, null))).then(Commands.argument((String)"location", (ArgumentType)Vec3Argument.vec3()).executes(ctx -> CommandTPX.teleportToPos((CommandSourceStack)ctx.getSource(), Collections.singleton(((CommandSourceStack)ctx.getSource()).getEntityOrException()), DimensionArgument.getDimension((CommandContext)ctx, (String)"dimension"), Vec3Argument.getCoordinates((CommandContext)ctx, (String)"location"), null))))).then(Commands.argument((String)"destination", (ArgumentType)EntityArgument.entity()).executes(ctx -> CommandTPX.teleportToEntity((CommandSourceStack)ctx.getSource(), Collections.singleton(((CommandSourceStack)ctx.getSource()).getEntityOrException()), EntityArgument.getEntity((CommandContext)ctx, (String)"destination"))))).then(((RequiredArgumentBuilder)Commands.argument((String)"targets", (ArgumentType)EntityArgument.entities()).then(Commands.argument((String)"destination", (ArgumentType)EntityArgument.entity()).executes(ctx -> CommandTPX.teleportToEntity((CommandSourceStack)ctx.getSource(), EntityArgument.getEntities((CommandContext)ctx, (String)"targets"), EntityArgument.getEntity((CommandContext)ctx, (String)"destination"))))).then(((RequiredArgumentBuilder)Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).executes(ctx -> CommandTPX.teleportToPos((CommandSourceStack)ctx.getSource(), EntityArgument.getEntities((CommandContext)ctx, (String)"targets"), DimensionArgument.getDimension((CommandContext)ctx, (String)"dimension"), new EntityLocation(((CommandSourceStack)ctx.getSource()).getEntityOrException()), null))).then(Commands.argument((String)"location", (ArgumentType)Vec3Argument.vec3()).executes(ctx -> CommandTPX.teleportToPos((CommandSourceStack)ctx.getSource(), EntityArgument.getEntities((CommandContext)ctx, (String)"targets"), DimensionArgument.getDimension((CommandContext)ctx, (String)"dimension"), Vec3Argument.getCoordinates((CommandContext)ctx, (String)"location"), null))))));
    }

    private static int teleportToEntity(CommandSourceStack source, Collection<? extends Entity> targets, Entity destination) {
        for (Entity entity : targets) {
            CommandTPX.teleport(source, entity, (ServerLevel)destination.level(), destination.getX(), destination.getY(), destination.getZ(), EnumSet.noneOf(RelativeMovement.class), destination.getYRot(), destination.getXRot());
        }
        if (targets.size() == 1) {
            source.sendSuccess(() -> Component.translatable((String)"commands.teleport.success.entity.single", (Object[])new Object[]{((Entity)targets.iterator().next()).getDisplayName(), destination.getDisplayName()}), true);
        } else {
            source.sendSuccess(() -> Component.translatable((String)"commands.teleport.success.entity.multiple", (Object[])new Object[]{targets.size(), destination.getDisplayName()}), true);
        }
        return targets.size();
    }

    private static int teleportToPos(CommandSourceStack source, Collection<? extends Entity> targets, ServerLevel targetWorld, @Nullable Coordinates position, @Nullable Coordinates rotationIn) throws CommandSyntaxException {
        if (position == null) {
            BlockPos pos = new BlockPos(0, 127, 0);
            rand.setSeed(0L);
            for (int i = 0; i < 1000; ++i) {
                pos = i < 500 ? new BlockPos(-150 + rand.nextInt(300), 32 + rand.nextInt(80), -150 + rand.nextInt(300)) : new BlockPos(-250 + rand.nextInt(500), 256, -250 + rand.nextInt(500));
                if (!targetWorld.isEmptyBlock(pos)) continue;
                while (targetWorld.isEmptyBlock(pos.below()) && targetWorld.isInWorldBounds(pos.below())) {
                    pos = pos.below();
                }
                BlockState state = targetWorld.getBlockState(pos.below());
                if (state.getFluidState().isEmpty() && state.blocksMotion()) break;
            }
            position = new BlockLocation(pos);
        }
        Vec3 vec3d = position.getPosition(source);
        Vec2 vec2f = rotationIn == null ? null : rotationIn.getRotation(source);
        EnumSet<RelativeMovement> set = EnumSet.noneOf(RelativeMovement.class);
        if (position.isXRelative()) {
            set.add(RelativeMovement.X);
        }
        if (position.isYRelative()) {
            set.add(RelativeMovement.Y);
        }
        if (position.isZRelative()) {
            set.add(RelativeMovement.Z);
        }
        if (rotationIn == null) {
            set.add(RelativeMovement.X_ROT);
            set.add(RelativeMovement.Y_ROT);
        } else {
            if (rotationIn.isXRelative()) {
                set.add(RelativeMovement.X_ROT);
            }
            if (rotationIn.isYRelative()) {
                set.add(RelativeMovement.Y_ROT);
            }
        }
        for (Entity entity : targets) {
            if (rotationIn == null) {
                CommandTPX.teleport(source, entity, targetWorld, vec3d.x, vec3d.y, vec3d.z, set, entity.getYRot(), entity.getXRot());
                continue;
            }
            CommandTPX.teleport(source, entity, targetWorld, vec3d.x, vec3d.y, vec3d.z, set, vec2f.y, vec2f.x);
        }
        if (targets.size() == 1) {
            source.sendSuccess(() -> Component.translatable((String)"commands.teleport.success.location.single", (Object[])new Object[]{((Entity)targets.iterator().next()).getDisplayName(), vec3d.x, vec3d.y, vec3d.z}), true);
        } else {
            source.sendSuccess(() -> Component.translatable((String)"commands.teleport.success.location.multiple", (Object[])new Object[]{targets.size(), vec3d.x, vec3d.y, vec3d.z}), true);
        }
        return targets.size();
    }

    private static void teleport(CommandSourceStack source, Entity entityIn, ServerLevel worldIn, double x, double y, double z, Set<RelativeMovement> relativeList, float yaw, float pitch) {
        if (entityIn instanceof ServerPlayer) {
            ChunkPos chunkpos = new ChunkPos(BlockPos.containing((double)x, (double)y, (double)z));
            worldIn.getChunkSource().addRegionTicket(TicketType.POST_TELEPORT, chunkpos, 1, (Object)entityIn.getId());
            entityIn.stopRiding();
            if (((ServerPlayer)entityIn).isSleeping()) {
                ((ServerPlayer)entityIn).stopSleeping();
            }
            if (worldIn == entityIn.level()) {
                ((ServerPlayer)entityIn).connection.teleport(x, y, z, yaw, pitch, relativeList);
            } else {
                ((ServerPlayer)entityIn).teleportTo(worldIn, x, y, z, yaw, pitch);
            }
            entityIn.setYHeadRot(yaw);
        } else {
            float wrapYaw = Mth.wrapDegrees((float)yaw);
            float wrapPitch = Mth.wrapDegrees((float)pitch);
            wrapPitch = Mth.clamp((float)wrapPitch, (float)-90.0f, (float)90.0f);
            if (worldIn == entityIn.level()) {
                entityIn.moveTo(x, y, z, wrapYaw, wrapPitch);
                entityIn.setYHeadRot(wrapYaw);
            } else {
                entityIn.unRide();
                entityIn.changeDimension(new DimensionTransition(worldIn, new Vec3(x, y, z), entityIn.getDeltaMovement(), wrapYaw, wrapPitch, DimensionTransition.DO_NOTHING));
                Entity entity = entityIn;
                entityIn = entityIn.getType().create((Level)worldIn);
                if (entityIn == null) {
                    return;
                }
                entityIn.restoreFrom(entity);
                entityIn.moveTo(x, y, z, wrapYaw, wrapPitch);
                entityIn.setYHeadRot(wrapYaw);
                worldIn.addDuringTeleport(entityIn);
            }
        }
        if (!(entityIn instanceof LivingEntity) || !((LivingEntity)entityIn).isFallFlying()) {
            entityIn.setDeltaMovement(entityIn.getDeltaMovement().multiply(1.0, 0.0, 1.0));
            entityIn.setOnGround(true);
        }
    }

    private static class BlockLocation
    implements Coordinates {
        private BlockPos pos;

        public BlockLocation(BlockPos pos) {
            this.pos = pos;
        }

        public Vec3 getPosition(CommandSourceStack source) {
            return Vec3.atCenterOf((Vec3i)this.pos);
        }

        public Vec2 getRotation(CommandSourceStack source) {
            return source.getRotation();
        }

        public boolean isXRelative() {
            return false;
        }

        public boolean isYRelative() {
            return false;
        }

        public boolean isZRelative() {
            return false;
        }
    }

    private static class EntityLocation
    implements Coordinates {
        private Entity entity;

        public EntityLocation(Entity entity) {
            this.entity = entity;
        }

        public Vec3 getPosition(CommandSourceStack source) {
            return this.entity.position();
        }

        public Vec2 getRotation(CommandSourceStack source) {
            return source.getRotation();
        }

        public boolean isXRelative() {
            return false;
        }

        public boolean isYRelative() {
            return false;
        }

        public boolean isZRelative() {
            return false;
        }
    }
}

