/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui;

import codechicken.lib.gui.modular.elements.GuiEnergyBar;
import codechicken.lib.gui.modular.elements.GuiRectangle;
import codechicken.lib.gui.modular.lib.GuiRender;
import codechicken.lib.gui.modular.lib.geometry.GuiParent;
import codechicken.lib.gui.modular.sprite.Material;
import codechicken.lib.render.buffer.TransformingVertexConsumer;
import codechicken.lib.util.FormatUtil;
import com.brandon3055.brandonscore.api.power.IOInfo;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.client.BCGuiTextures;
import com.brandon3055.brandonscore.client.shader.BCShaders;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import com.brandon3055.brandonscore.utils.Utils;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShaderEnergyBar
extends GuiEnergyBar {
    private static final RenderType SHADER_TYPE = RenderType.create((String)"starfield", (VertexFormat)DefaultVertexFormat.POSITION, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(new RenderStateShard.ShaderStateShard(() -> BCShaders.energyBarShader)).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(BCGuiTextures.TEXTURES.getAtlasHolder().atlasLocation(), false, false)).createCompositeState(false));
    private Supplier<Boolean> shaderEnabled = () -> true;
    private Supplier<Boolean> disabled = () -> false;

    public ShaderEnergyBar(@NotNull GuiParent<?> parent) {
        super(parent);
    }

    public static BiFunction<Long, Long, List<Component>> opEnergyFormatter(@Nullable IOPStorage storage) {
        return (energy, capacity) -> {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            tooltip.add(Component.translatable((String)"mod_gui.brandonscore.energy_bar.operational_potential").withStyle(ChatFormatting.DARK_AQUA));
            boolean shift = Screen.hasShiftDown();
            tooltip.add(Component.translatable((String)"mod_gui.brandonscore.energy_bar.capacity").withStyle(ChatFormatting.GOLD).append(" ").append((Component)Component.literal((String)(shift ? FormatUtil.addCommas((long)capacity) : FormatUtil.formatNumber((long)capacity))).withStyle(ChatFormatting.GRAY).append(" ").append((Component)Component.translatable((String)"mod_gui.brandonscore.energy_bar.op").withStyle(ChatFormatting.GRAY))));
            tooltip.add(Component.translatable((String)"mod_gui.brandonscore.energy_bar.stored").withStyle(ChatFormatting.GOLD).append(" ").append((Component)Component.literal((String)(shift ? FormatUtil.addCommas((long)energy) : FormatUtil.formatNumber((long)energy))).withStyle(ChatFormatting.GRAY)).append(" ").append((Component)Component.translatable((String)"mod_gui.brandonscore.energy_bar.op").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)String.format(" (%.2f%%)", (double)energy.longValue() / (double)capacity.longValue() * 100.0)).withStyle(ChatFormatting.GRAY)));
            if (storage != null && storage.getIOInfo() != null) {
                IOInfo ioInfo = storage.getIOInfo();
                if (Screen.hasShiftDown()) {
                    tooltip.add(Component.translatable((String)"mod_gui.brandonscore.energy_bar.input").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)" +").withStyle(ChatFormatting.GREEN).append(Utils.formatNumber(ioInfo.currentInput()))));
                    tooltip.add(Component.translatable((String)"mod_gui.brandonscore.energy_bar.output").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)" -").withStyle(ChatFormatting.RED).append(Utils.formatNumber(ioInfo.currentOutput()))));
                } else {
                    long io = ioInfo.currentInput() - ioInfo.currentOutput();
                    tooltip.add(Component.translatable((String)"mod_gui.brandonscore.energy_bar.io").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)((io > 0L ? " +" : " ") + io + " ")).withStyle(io > 0L ? ChatFormatting.GREEN : (io < 0L ? ChatFormatting.RED : ChatFormatting.GRAY)).append((Component)Component.translatable((String)"mod_gui.brandonscore.energy_bar.op"))));
                }
            }
            return tooltip;
        };
    }

    public ShaderEnergyBar setShaderEnabled(Supplier<Boolean> shaderEnabled) {
        this.shaderEnabled = shaderEnabled;
        return this;
    }

    public GuiEnergyBar setDisabled(Supplier<Boolean> disabled) {
        this.disabled = disabled;
        return this;
    }

    public ShaderEnergyBar bindOpStorage(@Nullable IOPStorage storage) {
        if (storage == null) {
            this.setEnergy(0L).setCapacity(0L);
        } else {
            this.setEnergy(storage::getOPStored).setCapacity(storage::getMaxOPStored);
        }
        return this;
    }

    public ShaderEnergyBar setItemSupplier(Supplier<ItemStack> stackSupplier) {
        this.setCapacity(() -> EnergyUtils.isEnergyItem((ItemStack)stackSupplier.get()) ? EnergyUtils.getMaxEnergyStored((ItemStack)stackSupplier.get()) : 0L);
        this.setEnergy(() -> EnergyUtils.isEnergyItem((ItemStack)stackSupplier.get()) ? EnergyUtils.getEnergyStored((ItemStack)stackSupplier.get()) : 0L);
        return this;
    }

    public void renderBackground(GuiRender render, double mouseX, double mouseY, float partialTicks) {
        double charge;
        boolean horizontal = this.xSize() > this.ySize();
        double barLength = horizontal ? this.xSize() : this.ySize();
        double barWidth = horizontal ? this.ySize() : this.xSize();
        double d = charge = this.getCapacity() <= 0L ? 0.0 : (double)this.getEnergy() / (double)this.getCapacity();
        if (Double.isNaN(charge)) {
            charge = 0.0;
        }
        double draw = charge * barLength;
        double posY = this.yMin();
        double posX = this.xMin();
        if (horizontal) {
            double x = posY;
            posY = posX;
            posX = x;
            render.pose().pushPose();
            render.pose().translate(barLength + posY * 2.0, 0.0, 0.0);
            render.pose().mulPose(Axis.ZP.rotationDegrees(90.0f));
        }
        MultiBufferSource.BufferSource getter = render.buffers();
        if (this.disabled.get().booleanValue()) {
            render.rect(posX, posY, barWidth, barLength, -16777216);
        } else if (!this.shaderEnabled.get().booleanValue()) {
            Material matBase = BCGuiTextures.get("bars/energy_empty");
            Material matOverlay = BCGuiTextures.get("bars/energy_full");
            TransformingVertexConsumer shaderConsumer = new TransformingVertexConsumer(matBase.buffer((MultiBufferSource)getter, GuiRender::texColType), render.pose());
            this.sliceSprite((VertexConsumer)shaderConsumer, posX, posY, barWidth, barLength, matBase.sprite());
            this.sliceSprite((VertexConsumer)shaderConsumer, posX, posY + barLength - draw, barWidth, draw, matOverlay.sprite());
        } else {
            Rectangle rect = this.toScreenSpace(this.xMin(), this.yMin(), this.xSize(), this.ySize());
            BCShaders.energyBarCharge.glUniform1f((float)charge * 1.01f);
            BCShaders.energyBarEPos.glUniform2i(rect.x, rect.y);
            BCShaders.energyBarESize.glUniform2i(rect.width, rect.height);
            BCShaders.energyBarScreenSize.glUniform2i(this.mc().getWindow().getWidth(), this.mc().getWindow().getHeight());
            TransformingVertexConsumer shaderConsumer = new TransformingVertexConsumer(getter.getBuffer(SHADER_TYPE), render.pose());
            this.drawShaderRect((VertexConsumer)shaderConsumer, (float)posX, (float)posY, (float)barWidth, (float)barLength);
        }
        getter.endBatch();
        if (horizontal) {
            render.pose().popPose();
        }
    }

    private void drawShaderRect(VertexConsumer buffer, float x, float y, float width, float height) {
        buffer.addVertex(x, y + height, 0.0f);
        buffer.addVertex(x + width, y + height, 0.0f);
        buffer.addVertex(x + width, y, 0.0f);
        buffer.addVertex(x, y, 0.0f);
    }

    public void sliceSprite(VertexConsumer buffer, double xPos, double yPos, double xSize, double ySize, TextureAtlasSprite sprite) {
        float texU = sprite.getU0();
        float texV = sprite.getV0();
        int texWidth = sprite.contents().width();
        int texHeight = sprite.contents().height();
        float uScale = (sprite.getU1() - texU) / (float)texWidth;
        float vScale = (sprite.getV1() - texV) / (float)texHeight;
        for (double i = 0.0; i < ySize; i += Math.min((double)(texHeight - 2), ySize - i)) {
            double partSize = Math.min((double)texHeight, ySize - i);
            this.bufferRect(buffer, (float)xPos, (float)yPos + (float)ySize - (float)i, (float)xSize, (float)(-partSize), sprite.getU0(), sprite.getV0(), (float)xSize * uScale, (float)partSize * vScale);
        }
    }

    private void bufferRect(VertexConsumer buffer, float x, float y, float width, float height, float minU, float minV, float tWidth, float tHeight) {
        buffer.addVertex(x, y + height, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(minU, minV + tHeight);
        buffer.addVertex(x + width, y + height, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(minU + tWidth, minV + tHeight);
        buffer.addVertex(x + width, y, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(minU + tWidth, minV);
        buffer.addVertex(x, y, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(minU, minV);
    }

    public Rectangle toScreenSpace(double xPos, double yPos, double xSize, double ySize) {
        double yResScale = (double)this.mc().getWindow().getHeight() / (double)this.scaledScreenHeight();
        double xResScale = (double)this.mc().getWindow().getWidth() / (double)this.scaledScreenWidth();
        double scaledWidth = xSize * xResScale;
        double scaledHeight = ySize * yResScale;
        int x = (int)(xPos * xResScale);
        int y = (int)((double)this.mc().getWindow().getHeight() - yPos * yResScale - scaledHeight);
        return new Rectangle(x, y, (int)scaledWidth, (int)scaledHeight);
    }

    public record EnergyBar(GuiRectangle container, ShaderEnergyBar bar) {
    }
}

