/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.tile;

import net.byAqua3.avaritia.item.ItemJsonSingularity;
import net.byAqua3.avaritia.loader.AvaritiaBlocks;
import net.byAqua3.avaritia.loader.AvaritiaDataComponents;
import net.byAqua3.avaritia.loader.AvaritiaSingularities;
import net.byAqua3.avaritia.recipe.RecipeCompressor;
import net.byAqua3.avaritia.singularity.Singularity;
import net.byAqua3.avaritia.tile.TileMachine;
import net.byAqua3.avaritia.util.RecipeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TileNeutroniumCompressor
extends TileMachine
implements WorldlyContainer {
    public static int CONSUME_TICKS = 1;
    public final SimpleContainer matrix = new SimpleContainer(1){

        public void setChanged() {
            TileNeutroniumCompressor.this.setChanged();
        }
    };
    public final SimpleContainer result = new SimpleContainer(1){

        public void setChanged() {
            TileNeutroniumCompressor.this.setChanged();
        }
    };
    private ItemStack targetStack = ItemStack.EMPTY;
    private int compressionTarget;
    private int consumptionProgress;
    private int compressionProgress;
    public final ContainerData dataAccess = new ContainerData(){

        public int get(int index) {
            switch (index) {
                case 0: {
                    return TileNeutroniumCompressor.this.compressionTarget;
                }
                case 1: {
                    return TileNeutroniumCompressor.this.consumptionProgress;
                }
                case 2: {
                    return TileNeutroniumCompressor.this.compressionProgress;
                }
                case 3: {
                    return BuiltInRegistries.ITEM.getId((Object)TileNeutroniumCompressor.this.targetStack.getItem());
                }
                case 4: {
                    if (TileNeutroniumCompressor.this.targetStack.getItem() instanceof ItemJsonSingularity) {
                        String singularityId = (String)TileNeutroniumCompressor.this.targetStack.getOrDefault(AvaritiaDataComponents.SINGULARITY_ID, (Object)"null");
                        Singularity singularity = AvaritiaSingularities.getInstance().getSingularity(singularityId);
                        if (singularity != null) {
                            return AvaritiaSingularities.getInstance().getSingularities().indexOf(singularity);
                        }
                    }
                    return -1;
                }
            }
            return 0;
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    TileNeutroniumCompressor.this.compressionTarget = value;
                    break;
                }
                case 1: {
                    TileNeutroniumCompressor.this.consumptionProgress = value;
                    break;
                }
                case 2: {
                    TileNeutroniumCompressor.this.compressionProgress = value;
                }
            }
        }

        public int getCount() {
            return 5;
        }
    };

    public TileNeutroniumCompressor(BlockPos pos, BlockState state) {
        super((BlockEntityType)AvaritiaBlocks.COMPRESSOR_TILE.get(), pos, state);
    }

    public ItemStack getTargetStack() {
        return this.targetStack;
    }

    public void onLoad() {
        super.onLoad();
        if (this.compressionTarget == -1) {
            RecipeCompressor recipe = RecipeUtils.getCompressorRecipeFromResult(this.level, this.targetStack);
            if (recipe == null) {
                this.targetStack = ItemStack.EMPTY;
                this.compressionTarget = 0;
                this.consumptionProgress = 0;
                this.compressionProgress = 0;
            } else {
                this.compressionTarget = recipe.getCost();
            }
        }
    }

    @Override
    protected boolean canWork() {
        ItemStack matrixItem = this.matrix.getItem(0);
        if (matrixItem.isEmpty()) {
            return false;
        }
        RecipeCompressor recipe = RecipeUtils.getCompressorRecipe(this.level, matrixItem);
        if (recipe == null) {
            return false;
        }
        if (!this.targetStack.isEmpty()) {
            return ItemStack.isSameItemSameComponents((ItemStack)recipe.getResultItem((HolderLookup.Provider)this.level.registryAccess()), (ItemStack)this.targetStack);
        }
        ItemStack resultItem = this.result.getItem(0);
        if (resultItem.isEmpty()) {
            return true;
        }
        return ItemStack.isSameItemSameComponents((ItemStack)recipe.getResultItem((HolderLookup.Provider)this.level.registryAccess()), (ItemStack)resultItem) && resultItem.getCount() < resultItem.getMaxStackSize();
    }

    @Override
    protected void doWork() {
        ItemStack matrixItem;
        RecipeCompressor recipe;
        if (this.targetStack.isEmpty() && (recipe = RecipeUtils.getCompressorRecipe(this.level, matrixItem = this.matrix.getItem(0))) != null) {
            this.targetStack = recipe.getResultItem((HolderLookup.Provider)this.level.registryAccess());
            this.compressionTarget = recipe.getCost();
        }
        ++this.consumptionProgress;
        if (this.consumptionProgress >= CONSUME_TICKS) {
            this.consumptionProgress = 0;
            matrixItem = this.matrix.getItem(0);
            matrixItem.setCount(matrixItem.getCount() - 1);
            ++this.compressionProgress;
        }
        if (this.compressionProgress >= this.compressionTarget) {
            this.compressionProgress = 0;
            ItemStack resultItem = this.result.getItem(0);
            if (resultItem.isEmpty()) {
                this.result.setItem(0, this.targetStack.copy());
            } else {
                resultItem.setCount(resultItem.getCount() + 1);
            }
            this.targetStack = ItemStack.EMPTY;
        }
    }

    @Override
    protected void onWorkStopped() {
        this.consumptionProgress = 0;
    }

    public int getContainerSize() {
        return 2;
    }

    public boolean isEmpty() {
        return this.matrix.isEmpty() && this.result.isEmpty();
    }

    public ItemStack getItem(int slot) {
        if (slot == 0) {
            return this.matrix.getItem(0);
        }
        return this.result.getItem(0);
    }

    public ItemStack removeItem(int slot, int amount) {
        if (slot == 0) {
            return this.matrix.removeItem(0, amount);
        }
        if (slot == 1) {
            return this.result.removeItem(0, amount);
        }
        return ItemStack.EMPTY;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        if (slot == 0) {
            return this.matrix.removeItemNoUpdate(0);
        }
        if (slot == 1) {
            return this.result.removeItemNoUpdate(0);
        }
        return ItemStack.EMPTY;
    }

    public void setItem(int slot, ItemStack stack) {
        if (slot == 0) {
            this.matrix.setItem(0, stack);
        } else if (slot == 1) {
            this.result.setItem(0, stack);
        }
    }

    public boolean stillValid(Player player) {
        BlockPos blockPos = this.getBlockPos();
        return this.getLevel().getBlockEntity(blockPos) == this && player.distanceToSqr((double)blockPos.getX() + 0.5, (double)blockPos.getY() + 0.5, (double)blockPos.getZ() + 0.5) <= 64.0;
    }

    public void clearContent() {
    }

    public int[] getSlotsForFace(Direction direction) {
        if (direction == Direction.UP) {
            return new int[]{0};
        }
        return new int[]{1};
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack stack, Direction direction) {
        if (stack.isEmpty()) {
            return false;
        }
        if (index == 0) {
            if (this.targetStack.isEmpty()) {
                return true;
            }
            RecipeCompressor recipe = RecipeUtils.getCompressorRecipe(this.level, stack);
            if (recipe == null) {
                return false;
            }
            if (!this.targetStack.isEmpty()) {
                return ItemStack.isSameItemSameComponents((ItemStack)recipe.getResultItem((HolderLookup.Provider)this.level.registryAccess()), (ItemStack)this.targetStack);
            }
        }
        return false;
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        return index == 1 && direction != Direction.UP;
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        int j;
        CompoundTag compoundTag;
        int i;
        ListTag tagList;
        super.loadAdditional(tag, provider);
        this.compressionTarget = -1;
        this.consumptionProgress = tag.getInt("consumptionProgress");
        this.compressionProgress = tag.getInt("compressionProgress");
        this.targetStack = ItemStack.parse((HolderLookup.Provider)provider, (Tag)tag.getCompound("target")).orElse(ItemStack.EMPTY);
        if (tag.contains("Matrix", 9)) {
            tagList = tag.getList("Matrix", 10);
            for (i = 0; i < tagList.size(); ++i) {
                compoundTag = tagList.getCompound(i);
                j = compoundTag.getByte("Slot") & 0xFF;
                if (j < 0 || j >= this.matrix.getItems().size()) continue;
                this.matrix.getItems().set(j, (Object)ItemStack.parse((HolderLookup.Provider)provider, (Tag)compoundTag).orElse(ItemStack.EMPTY));
            }
        }
        if (tag.contains("Result", 9)) {
            tagList = tag.getList("Result", 10);
            for (i = 0; i < tagList.size(); ++i) {
                compoundTag = tagList.getCompound(i);
                j = compoundTag.getByte("Slot") & 0xFF;
                if (j < 0 || j >= this.result.getItems().size()) continue;
                this.result.getItems().set(j, (Object)ItemStack.parse((HolderLookup.Provider)provider, (Tag)compoundTag).orElse(ItemStack.EMPTY));
            }
        }
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putInt("consumptionProgress", this.consumptionProgress);
        tag.putInt("compressionProgress", this.compressionProgress);
        if (!this.targetStack.isEmpty()) {
            tag.put("target", this.targetStack.save(provider, (Tag)new CompoundTag()));
        }
        ListTag tagListMatrix = new ListTag();
        for (int i = 0; i < this.matrix.getItems().size(); ++i) {
            ItemStack itemStack = (ItemStack)this.matrix.getItems().get(i);
            if (itemStack.isEmpty()) continue;
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.putByte("Slot", (byte)i);
            tagListMatrix.add((Object)itemStack.save(provider, (Tag)compoundTag));
        }
        if (!tagListMatrix.isEmpty()) {
            tag.put("Matrix", (Tag)tagListMatrix);
        }
        ListTag tagListResult = new ListTag();
        for (int i = 0; i < this.result.getItems().size(); ++i) {
            ItemStack itemStack = (ItemStack)this.result.getItems().get(i);
            if (itemStack.isEmpty()) continue;
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.putByte("Slot", (byte)i);
            tagListResult.add((Object)itemStack.save(provider, (Tag)compoundTag));
        }
        if (!tagListResult.isEmpty()) {
            tag.put("Result", (Tag)tagListResult);
        }
    }
}

