/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import com.mojang.math.Transformation;
import java.awt.Color;
import java.util.List;
import net.byAqua3.avaritia.entity.EntityGapingVoid;
import net.byAqua3.avaritia.loader.AvaritiaRenderTypes;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.model.SimpleModelState;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.obj.ObjLoader;
import net.neoforged.neoforge.client.model.obj.ObjModel;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class RenderGapingVoid<T extends EntityGapingVoid>
extends EntityRenderer<T> {
    public static final ResourceLocation VOID = ResourceLocation.tryBuild((String)"avaritia", (String)"textures/entity/void/void.png");
    public static final ResourceLocation VOID_HALO = ResourceLocation.tryBuild((String)"avaritia", (String)"textures/entity/void/void_halo.png");
    public static final Material VOID_MATERIAL = new Material(InventoryMenu.BLOCK_ATLAS, ResourceLocation.tryBuild((String)"avaritia", (String)"entity/void/void"));
    private ObjModel objModel;
    private final IGeometryBakingContext objModelContext = new IGeometryBakingContext(this){

        public String getModelName() {
            return "gaping_void";
        }

        public boolean hasMaterial(String name) {
            return true;
        }

        public Material getMaterial(String name) {
            return VOID_MATERIAL;
        }

        public boolean isGui3d() {
            return false;
        }

        public boolean useBlockLight() {
            return false;
        }

        public boolean useAmbientOcclusion() {
            return false;
        }

        public ItemTransforms getTransforms() {
            return ItemTransforms.NO_TRANSFORMS;
        }

        public Transformation getRootTransform() {
            return Transformation.identity();
        }

        @Nullable
        public ResourceLocation getRenderTypeHint() {
            return null;
        }

        public boolean isComponentVisible(String component, boolean fallback) {
            return true;
        }
    };

    public RenderGapingVoid(EntityRendererProvider.Context context) {
        super(context);
        this.initObjModel();
    }

    private void initObjModel() {
        ObjModel.ModelSettings modelSettings = new ObjModel.ModelSettings(ResourceLocation.tryBuild((String)"avaritia", (String)"model/model.obj"), false, false, false, false, "avaritia:model/model.mtl");
        this.objModel = ObjLoader.INSTANCE.loadModel(modelSettings);
    }

    private Color getColor(double age) {
        double life = age / 186.0;
        double f = Math.max(0.0, (life - 0.95) / 0.050000000000000044);
        f = Math.max(f, 1.0 - life * 30.0);
        return new Color((float)f, (float)f, (float)f, 1.0f);
    }

    public void render(EntityGapingVoid livingEntity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
        VertexConsumer vertexConsumer = multiBufferSource.getBuffer(AvaritiaRenderTypes.VOID);
        Color color = this.getColor(livingEntity.getAge());
        float scale = (float)EntityGapingVoid.getVoidScale(livingEntity.getAge());
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        float a = (float)color.getAlpha() / 255.0f;
        double halocoord = 0.58 * (double)scale;
        double haloscaledist = 2.2 * (double)scale;
        Vec3 camera = this.entityRenderDispatcher.camera.getPosition();
        double dx = livingEntity.getX() - camera.x();
        double dy = livingEntity.getY() - camera.y();
        double dz = livingEntity.getZ() - camera.z();
        double xzlen = Math.sqrt(dx * dx + dz * dz);
        double len = Math.sqrt(dx * dx + dy * dy + dz * dz);
        if (len <= haloscaledist) {
            double close = (haloscaledist - len) / haloscaledist;
            halocoord *= 1.0 + close * close * close * close * 1.5;
        }
        double yang = Math.atan2(xzlen, dy) * 57.29577951308232;
        double xang = Math.atan2(dx, dz) * 57.29577951308232;
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.5f, 0.5f);
        poseStack.mulPose(Axis.YP.rotationDegrees((float)xang));
        poseStack.mulPose(Axis.XP.rotationDegrees((float)(yang + 275.0)));
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)VOID_HALO);
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        Matrix4f matrix4f = poseStack.last().pose();
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        bufferBuilder.addVertex(matrix4f, (float)(-halocoord), (float)(-halocoord), 0.0f).setColor(r, g, b, a).setUv(0.0f, 0.0f);
        bufferBuilder.addVertex(matrix4f, (float)(-halocoord), (float)halocoord, 0.0f).setColor(r, g, b, a).setUv(0.0f, 1.0f);
        bufferBuilder.addVertex(matrix4f, (float)halocoord, (float)halocoord, 0.0f).setColor(r, g, b, a).setUv(1.0f, 1.0f);
        bufferBuilder.addVertex(matrix4f, (float)halocoord, (float)(-halocoord), 0.0f).setColor(r, g, b, a).setUv(1.0f, 0.0f);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        poseStack.popPose();
        poseStack.pushPose();
        PoseStack.Pose poseStack$pose = poseStack.last();
        poseStack.translate(0.5f, 0.25f, 0.5f);
        poseStack.scale(scale - 0.1f, scale - 0.1f, scale - 0.1f);
        if (this.objModel != null) {
            BakedModel bakedModel = this.objModel.bake(this.objModelContext, null, material -> material.sprite(), (ModelState)new SimpleModelState(Transformation.identity()), ItemOverrides.EMPTY);
            RandomSource randomSource = RandomSource.create();
            randomSource.setSeed(42L);
            List quads = bakedModel.getQuads(null, null, randomSource, ModelData.EMPTY, null);
            for (BakedQuad quad : quads) {
                vertexConsumer.putBulkData(poseStack$pose, quad, r, g, b, a, packedLight, OverlayTexture.NO_OVERLAY, true);
            }
        }
        poseStack.popPose();
    }

    public ResourceLocation getTextureLocation(EntityGapingVoid entity) {
        return VOID;
    }
}

