/*
 * Decompiled with CFR 0.152.
 */
package net.byAqua3.avaritia.item;

import net.byAqua3.avaritia.entity.EntityInfinityArrow;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.EventHooks;

public class ItemInfinityBow
extends BowItem {
    public static int DRAW_TIME = 8;

    public ItemInfinityBow(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    public boolean isFoil(ItemStack stack) {
        return false;
    }

    public int getUseDuration(ItemStack stack, LivingEntity livingEntity) {
        return 13;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        InteractionResultHolder ret = EventHooks.onArrowNock((ItemStack)stack, (Level)level, (Player)player, (InteractionHand)hand, (boolean)true);
        if (ret != null) {
            return ret;
        }
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)stack);
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack stack, int time) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (time == 1) {
                int l;
                int k;
                int max = this.getUseDuration(stack, livingEntity);
                float maxf = max;
                int j = max;
                float f = (float)j / maxf;
                if ((f = (f * f + f * 2.0f) / 3.0f) < 0.1f) {
                    return;
                }
                if (f > 1.0f) {
                    f = 1.0f;
                }
                EntityInfinityArrow arrow = new EntityInfinityArrow(level, false);
                arrow.setPos(player.getX(), player.getEyeY(), player.getZ());
                arrow.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, f * 3.0f, 1.0f);
                arrow.setBaseDamage(1000.0);
                arrow.setOwner((Entity)player);
                if (f == 1.0f) {
                    arrow.setCritArrow(true);
                }
                if ((k = EnchantmentHelper.getItemEnchantmentLevel((Holder)level.registryAccess().holderOrThrow(Enchantments.POWER), (ItemStack)stack)) > 0) {
                    arrow.setBaseDamage(arrow.getBaseDamage() + (double)k * 0.5 + 0.5);
                }
                if ((l = EnchantmentHelper.getItemEnchantmentLevel((Holder)level.registryAccess().holderOrThrow(Enchantments.PUNCH), (ItemStack)stack)) > 0) {
                    arrow.setKnockback(l);
                }
                if (EnchantmentHelper.getItemEnchantmentLevel((Holder)level.registryAccess().holderOrThrow(Enchantments.FLAME), (ItemStack)stack) > 0) {
                    arrow.igniteForSeconds(100.0f);
                }
                arrow.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                if (!level.isClientSide()) {
                    level.addFreshEntity((Entity)arrow);
                }
                level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (level.random.nextFloat() * 0.4f + 1.2f) + 0.5f);
                player.awardStat(Stats.ITEM_USED.get((Object)this));
            }
        }
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity livingEntity, int time) {
    }

    public AbstractArrow customArrow(AbstractArrow arrow, ItemStack projectileStack, ItemStack weaponStack) {
        return new EntityInfinityArrow(arrow.level(), false);
    }
}

