/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.socket.gem.bonus.special;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.socket.gem.GemClass;
import dev.shadowsoffire.apotheosis.socket.gem.GemInstance;
import dev.shadowsoffire.apotheosis.socket.gem.GemView;
import dev.shadowsoffire.apotheosis.socket.gem.Purity;
import dev.shadowsoffire.apotheosis.socket.gem.bonus.GemBonus;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.util.AttributeTooltipContext;

public class MageSlayerBonus
extends GemBonus {
    public static Codec<MageSlayerBonus> CODEC = RecordCodecBuilder.create(inst -> inst.group(MageSlayerBonus.gemClass(), (App)Purity.mapCodec(Codec.floatRange((float)0.0f, (float)1.0f)).fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, MageSlayerBonus::new));
    protected final Map<Purity, Float> values;

    public MageSlayerBonus(GemClass gemClass, Map<Purity, Float> values) {
        super(gemClass);
        this.values = values;
    }

    @Override
    public float onHurt(GemInstance inst, DamageSource src, LivingEntity user, float amount) {
        float value = this.values.get(inst.purity()).floatValue();
        if (src.is(Tags.DamageTypes.IS_MAGIC)) {
            user.heal(amount * value);
            return amount * (1.0f - value);
        }
        return super.onHurt(inst, src, user, amount);
    }

    public Codec<? extends GemBonus> getCodec() {
        return CODEC;
    }

    @Override
    public Component getSocketBonusTooltip(GemView inst, AttributeTooltipContext ctx) {
        float value = this.values.get(inst.purity()).floatValue();
        return Component.translatable((String)("bonus." + String.valueOf(this.getTypeKey()) + ".desc"), (Object[])new Object[]{Affix.fmt(value * 100.0f)}).withStyle(ChatFormatting.YELLOW);
    }

    @Override
    public boolean supports(Purity purity) {
        return this.values.containsKey(purity);
    }
}

