/*
 * Decompiled with CFR 0.152.
 */
package vazkii.akashictome.network;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import vazkii.akashictome.MorphingHandler;
import vazkii.akashictome.Registries;

public record MessageMorphTome(String modid) implements CustomPacketPayload
{
    public static final StreamCodec<FriendlyByteBuf, MessageMorphTome> CODEC = CustomPacketPayload.codec(MessageMorphTome::serialize, MessageMorphTome::new);
    public static final CustomPacketPayload.Type<MessageMorphTome> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"akashictome", (String)"morph_tome"));

    public MessageMorphTome(FriendlyByteBuf buf) {
        this(buf.readUtf());
    }

    public void serialize(FriendlyByteBuf buf) {
        buf.writeUtf(this.modid);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    public static void handle(MessageMorphTome msg, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player patt0$temp = ctx.player();
            if (patt0$temp instanceof ServerPlayer) {
                boolean hasTome;
                ServerPlayer player = (ServerPlayer)patt0$temp;
                ItemStack tomeStack = player.getMainHandItem();
                InteractionHand hand = InteractionHand.MAIN_HAND;
                boolean bl = hasTome = !tomeStack.isEmpty() && tomeStack.is((Item)Registries.TOME.get());
                if (!hasTome) {
                    tomeStack = player.getOffhandItem();
                    hasTome = !tomeStack.isEmpty() && tomeStack.is((Item)Registries.TOME.get());
                    hand = InteractionHand.OFF_HAND;
                }
                if (hasTome) {
                    ItemStack newStack = MorphingHandler.getShiftStackForMod(tomeStack, msg.modid);
                    player.setItemInHand(hand, newStack);
                }
            }
        });
    }
}

