/*
 * Decompiled with CFR 0.152.
 */
package vazkii.akashictome;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import vazkii.akashictome.AkashicTome;
import vazkii.akashictome.MorphingHandler;
import vazkii.akashictome.Registries;
import vazkii.akashictome.data_components.ToolContentComponent;

public class TomeItem
extends Item {
    public TomeItem(Item.Properties properties) {
        super(properties.stacksTo(1).component(Registries.IS_MORPHED, (Object)false).component(Registries.TOOL_CONTENT, (Object)ToolContentComponent.EMPTY));
    }

    public InteractionResult useOn(UseOnContext context) {
        String mod;
        ItemStack newStack;
        Player playerIn = context.getPlayer();
        InteractionHand hand = context.getHand();
        Level worldIn = context.getLevel();
        BlockPos pos = context.getClickedPos();
        ItemStack stack = playerIn.getItemInHand(hand);
        if (playerIn.isShiftKeyDown() && !ItemStack.isSameItem((ItemStack)(newStack = MorphingHandler.getShiftStackForMod(stack, mod = MorphingHandler.getModFromState(worldIn.getBlockState(pos)))), (ItemStack)stack)) {
            playerIn.setItemInHand(hand, newStack);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        AkashicTome.proxy.openTomeGUI(playerIn, stack);
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)worldIn.isClientSide);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag advanced) {
        if (!stack.has(Registries.TOOL_CONTENT)) {
            return;
        }
        ToolContentComponent contents = (ToolContentComponent)stack.get(Registries.TOOL_CONTENT);
        if (contents == null || contents.isEmpty()) {
            return;
        }
        if (Screen.hasShiftDown()) {
            String currMod = "";
            for (ItemStack contentStack : contents.getItems()) {
                if (contentStack.isEmpty()) continue;
                Component name = contentStack.has(Registries.OG_DISPLAY_NAME) ? (Component)contentStack.get(Registries.OG_DISPLAY_NAME) : contentStack.getHoverName();
                String mod = MorphingHandler.getModFromStack(contentStack);
                if (!currMod.equals(mod)) {
                    tooltip.add((Component)Component.literal((String)MorphingHandler.getModNameForId(mod)).setStyle(Style.EMPTY.applyFormats(new ChatFormatting[]{ChatFormatting.AQUA})));
                }
                tooltip.add((Component)Component.literal((String)(" \u2520 " + name.getString())));
                currMod = mod;
            }
        } else {
            tooltip.add((Component)Component.translatable((String)"akashictome.misc.shift_for_info"));
        }
    }
}

