/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.blocks;

import appeng.block.crafting.ICraftingUnitType;
import appeng.core.definitions.BlockDefinition;
import net.minecraft.world.item.Item;
import net.pedroksl.advanced_ae.common.definitions.AAEBlocks;
import net.pedroksl.advanced_ae.common.definitions.AAEConfig;

public enum AAECraftingUnitType implements ICraftingUnitType
{
    QUANTUM_UNIT(0, "quantum_unit"),
    QUANTUM_CORE(256, "quantum_core"),
    STORAGE_128M(128, "quantum_storage_128"),
    STORAGE_256M(256, "quantum_storage_256"),
    STORAGE_MULTIPLIER(0, "data_entangler"),
    QUANTUM_ACCELERATOR(0, "quantum_accelerator"),
    MULTI_THREADER(0, "quantum_multi_threader"),
    STRUCTURE(0, "quantum_structure");

    private final int storageMb;
    private final String affix;

    private AAECraftingUnitType(int storageMb, String affix) {
        this.storageMb = storageMb;
        this.affix = affix;
    }

    public long getStorageBytes() {
        return 0x100000L * (long)this.storageMb;
    }

    public int getStorageMultiplier() {
        return this == STORAGE_MULTIPLIER ? AAEConfig.instance().getQuantumComputerDataEntanglerMultiplication() : 0;
    }

    public int getAcceleratorThreads() {
        return switch (this.ordinal()) {
            case 1, 5 -> AAEConfig.instance().getQuantumComputerAcceleratorThreads();
            default -> 0;
        };
    }

    public int getAccelerationMultiplier() {
        return this == MULTI_THREADER ? AAEConfig.instance().getQuantumComputerMultiThreaderMultiplication() : 0;
    }

    public String getAffix() {
        return this.affix;
    }

    public BlockDefinition<?> getDefinition() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> AAEBlocks.QUANTUM_UNIT;
            case 1 -> AAEBlocks.QUANTUM_CORE;
            case 2 -> AAEBlocks.QUANTUM_STORAGE_128M;
            case 3 -> AAEBlocks.QUANTUM_STORAGE_256M;
            case 4 -> AAEBlocks.DATA_ENTANGLER;
            case 5 -> AAEBlocks.QUANTUM_ACCELERATOR;
            case 6 -> AAEBlocks.QUANTUM_MULTI_THREADER;
            case 7 -> AAEBlocks.QUANTUM_STRUCTURE;
        };
    }

    public Item getItemFromType() {
        return this.getDefinition().asItem();
    }
}

