/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.ae2addonlib.recipes;

import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.GenericStack;
import com.google.common.primitives.Ints;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Predicate;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import org.jetbrains.annotations.Contract;

public abstract class IngredientStack<T extends Predicate<P>, P> {
    protected final T ingredient;
    protected int amount;

    IngredientStack(T ingredient, int amount) {
        this.ingredient = ingredient;
        this.amount = amount;
    }

    public static Item of(ItemStack stack) {
        return new Item(Ingredient.of((ItemStack[])new ItemStack[]{stack}), stack.getCount());
    }

    public static Item of(Ingredient ingredient, int amount) {
        return new Item(ingredient, amount);
    }

    public static Fluid of(FluidStack stack) {
        return new Fluid(stack);
    }

    public static Fluid of(FluidIngredient ingredient, int amount) {
        return new Fluid(ingredient, amount);
    }

    public T getIngredient() {
        return this.ingredient;
    }

    public int getAmount() {
        return this.amount;
    }

    @Contract(value="null -> false")
    public boolean test(Object stack) {
        if (stack == null) {
            return false;
        }
        return this.ingredient.test((Object)stack);
    }

    public abstract boolean test(GenericStack var1);

    public void consume(Object stack) {
        if (this.amount <= 0) {
            return;
        }
        if (this.ingredient.test((Object)stack)) {
            int from = this.getStackAmount(stack);
            if (from > this.amount) {
                this.setStackAmount(stack, from - this.amount);
                this.amount = 0;
            } else {
                this.setStackAmount(stack, 0);
                this.amount -= from;
            }
        }
    }

    public boolean isEmpty() {
        return this.amount <= 0;
    }

    public abstract IngredientStack<T, P> sample();

    public abstract boolean checkType(Object var1);

    public abstract int getStackAmount(P var1);

    public abstract void setStackAmount(P var1, int var2);

    public abstract void toNetwork(RegistryFriendlyByteBuf var1);

    public static final class Item
    extends IngredientStack<Ingredient, ItemStack> {
        public static final Codec<Item> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(i -> (Ingredient)i.ingredient), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("amount", (Object)1).forGetter(i -> i.amount)).apply((Applicative)builder, Item::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Item> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, f -> (Ingredient)f.ingredient, (StreamCodec)ByteBufCodecs.INT, f -> f.amount, Item::new);

        public Item(Ingredient ingredient, int amount) {
            super(ingredient, amount);
        }

        public Item sample() {
            return new Item((Ingredient)this.ingredient, this.amount);
        }

        @Override
        public boolean checkType(Object obj) {
            GenericStack gen;
            return obj instanceof ItemStack || obj instanceof GenericStack && (gen = (GenericStack)obj).what() instanceof AEItemKey;
        }

        @Override
        public boolean test(GenericStack stack) {
            if (!this.checkType(stack)) {
                return false;
            }
            ItemStack s = ((AEItemKey)stack.what()).toStack(Ints.saturatedCast((long)stack.amount()));
            return ((Ingredient)this.ingredient).test(s);
        }

        @Override
        public int getStackAmount(ItemStack stack) {
            return stack.getCount();
        }

        @Override
        public void setStackAmount(ItemStack stack, int amount) {
            stack.setCount(amount);
        }

        @Override
        public void toNetwork(RegistryFriendlyByteBuf buffer) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)((Ingredient)this.ingredient));
            buffer.writeInt(this.amount);
        }
    }

    public static class Fluid
    extends IngredientStack<FluidIngredient, FluidStack> {
        public static final Codec<Fluid> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)FluidIngredient.CODEC.fieldOf("ingredient").forGetter(f -> (FluidIngredient)f.ingredient), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("amount", (Object)1).forGetter(f -> f.amount)).apply((Applicative)builder, Fluid::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Fluid> STREAM_CODEC = StreamCodec.composite((StreamCodec)FluidIngredient.STREAM_CODEC, f -> (FluidIngredient)f.ingredient, (StreamCodec)ByteBufCodecs.INT, f -> f.amount, Fluid::new);

        public Fluid(FluidIngredient ingredient, int amount) {
            super(ingredient, amount);
        }

        public Fluid(FluidStack stack) {
            super(FluidIngredient.of((net.minecraft.world.level.material.Fluid[])new net.minecraft.world.level.material.Fluid[]{stack.getFluid()}), stack.getAmount());
        }

        public Fluid sample() {
            return new Fluid((FluidIngredient)this.ingredient, this.amount);
        }

        @Override
        public boolean checkType(Object obj) {
            GenericStack gen;
            return obj instanceof FluidStack || obj instanceof GenericStack && (gen = (GenericStack)obj).what() instanceof AEFluidKey;
        }

        @Override
        public boolean test(GenericStack stack) {
            if (!this.checkType(stack)) {
                return false;
            }
            FluidStack f = ((AEFluidKey)stack.what()).toStack(Ints.saturatedCast((long)stack.amount()));
            return ((FluidIngredient)this.ingredient).test(f);
        }

        @Override
        public int getStackAmount(FluidStack stack) {
            return stack.getAmount();
        }

        @Override
        public void setStackAmount(FluidStack stack, int amount) {
            stack.setAmount(amount);
        }

        @Override
        public void toNetwork(RegistryFriendlyByteBuf buffer) {
            buffer.writeJsonWithCodec(CODEC, (Object)this);
        }
    }
}

