/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.registries.holdersets;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.HolderSetCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.registries.holdersets.HolderSetType;
import net.neoforged.neoforge.registries.holdersets.ICustomHolderSet;
import org.jetbrains.annotations.Nullable;

public class NotHolderSet<T>
implements ICustomHolderSet<T> {
    private final List<Runnable> owners = new ArrayList<Runnable>();
    private final HolderLookup.RegistryLookup<T> registryLookup;
    private final HolderSet<T> value;
    @Nullable
    private List<Holder<T>> list = null;

    public HolderLookup.RegistryLookup<T> registryLookup() {
        return this.registryLookup;
    }

    public HolderSet<T> value() {
        return this.value;
    }

    public NotHolderSet(HolderLookup.RegistryLookup<T> registryLookup, HolderSet<T> value) {
        this.registryLookup = registryLookup;
        this.value = value;
        this.value.addInvalidationListener(this::invalidate);
    }

    @Override
    public HolderSetType type() {
        return (HolderSetType)NeoForgeMod.NOT_HOLDER_SET.value();
    }

    public void addInvalidationListener(Runnable runnable) {
        this.owners.add(runnable);
    }

    public Iterator<Holder<T>> iterator() {
        return this.getList().iterator();
    }

    public Stream<Holder<T>> stream() {
        return this.getList().stream();
    }

    public int size() {
        return this.getList().size();
    }

    public Either<TagKey<T>, List<Holder<T>>> unwrap() {
        return Either.right(this.getList());
    }

    public Optional<Holder<T>> getRandomElement(RandomSource random) {
        List<Holder<T>> list = this.getList();
        int size = list.size();
        return size > 0 ? Optional.of(list.get(random.nextInt(size))) : Optional.empty();
    }

    public Holder<T> get(int i) {
        return this.getList().get(i);
    }

    public boolean contains(Holder<T> holder) {
        return !this.value.contains(holder);
    }

    public boolean canSerializeIn(HolderOwner<T> holderOwner) {
        return this.value.canSerializeIn(holderOwner);
    }

    public Optional<TagKey<T>> unwrapKey() {
        return Optional.empty();
    }

    public String toString() {
        return "NotSet(" + String.valueOf(this.value) + ")";
    }

    private List<Holder<T>> getList() {
        List<Holder<T>> thisList = this.list;
        if (thisList == null) {
            List<Holder<T>> list = this.registryLookup.listElements().filter(holder -> !this.value.contains((Holder)holder)).map(holder -> holder).toList();
            this.list = list;
            return list;
        }
        return thisList;
    }

    private void invalidate() {
        this.list = null;
        for (Runnable runnable : this.owners) {
            runnable.run();
        }
    }

    public static class Type
    implements HolderSetType {
        @Override
        public <T> MapCodec<? extends ICustomHolderSet<T>> makeCodec(ResourceKey<? extends Registry<T>> registryKey, Codec<Holder<T>> holderCodec, boolean forceList) {
            return RecordCodecBuilder.mapCodec(builder -> builder.group((App)RegistryOps.retrieveRegistryLookup((ResourceKey)registryKey).forGetter(NotHolderSet::registryLookup), (App)HolderSetCodec.create((ResourceKey)registryKey, (Codec)holderCodec, (boolean)forceList).fieldOf("value").forGetter(NotHolderSet::value)).apply((Applicative)builder, NotHolderSet::new));
        }

        @Override
        public <T> StreamCodec<RegistryFriendlyByteBuf, ? extends ICustomHolderSet<T>> makeStreamCodec(final ResourceKey<? extends Registry<T>> registryKey) {
            return new StreamCodec<RegistryFriendlyByteBuf, NotHolderSet<T>>(){
                private final StreamCodec<RegistryFriendlyByteBuf, HolderSet<T>> holderSetCodec;
                {
                    this.holderSetCodec = ByteBufCodecs.holderSet((ResourceKey)registryKey);
                }

                public NotHolderSet<T> decode(RegistryFriendlyByteBuf buf) {
                    return new NotHolderSet(buf.registryAccess().lookupOrThrow(registryKey), (HolderSet)this.holderSetCodec.decode((Object)buf));
                }

                public void encode(RegistryFriendlyByteBuf buf, NotHolderSet<T> holderSet) {
                    this.holderSetCodec.encode((Object)buf, holderSet.value);
                }
            };
        }
    }
}

