/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.network.handling;

import io.netty.channel.ChannelHandlerContext;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.network.Connection;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.network.ConfigurationTask;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.common.extensions.ICommonPacketListener;
import net.neoforged.neoforge.network.registration.NetworkRegistry;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.NonExtendable
public interface IPayloadContext {
    public ICommonPacketListener listener();

    default public Connection connection() {
        return this.listener().getConnection();
    }

    public Player player();

    default public void reply(CustomPacketPayload payload) {
        this.listener().send(payload);
    }

    default public void disconnect(Component reason) {
        this.listener().disconnect(reason);
    }

    public CompletableFuture<Void> enqueueWork(Runnable var1);

    public <T> CompletableFuture<T> enqueueWork(Supplier<T> var1);

    public PacketFlow flow();

    default public ConnectionProtocol protocol() {
        return this.listener().protocol();
    }

    default public void handle(Packet<?> packet) {
        NetworkRegistry.handlePacketUnchecked(packet, this.listener());
    }

    public void handle(CustomPacketPayload var1);

    public void finishCurrentTask(ConfigurationTask.Type var1);

    default public ChannelHandlerContext channelHandlerContext() {
        return this.connection().channel().pipeline().lastContext();
    }
}

