/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.crafting;

import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;
import org.jetbrains.annotations.Nullable;

public class BlockTagIngredient
implements ICustomIngredient {
    public static final MapCodec<BlockTagIngredient> CODEC = TagKey.codec((ResourceKey)Registries.BLOCK).xmap(BlockTagIngredient::new, BlockTagIngredient::getTag).fieldOf("tag");
    protected final TagKey<Block> tag;
    @Nullable
    protected ItemStack[] itemStacks;

    public BlockTagIngredient(TagKey<Block> tag) {
        this.tag = tag;
    }

    protected void dissolve() {
        if (this.itemStacks == null) {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            for (Holder block : BuiltInRegistries.BLOCK.getTagOrEmpty(this.tag)) {
                ItemStack stack = new ItemStack((ItemLike)block.value());
                if (stack.isEmpty()) continue;
                list.add(stack);
            }
            if (list.isEmpty()) {
                ItemStack itemStack = new ItemStack((ItemLike)Blocks.BARRIER);
                itemStack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)("Empty Tag: " + String.valueOf(this.tag.location()))));
                list.add(itemStack);
            }
            this.itemStacks = (ItemStack[])list.toArray(ItemStack[]::new);
        }
    }

    @Override
    public Stream<ItemStack> getItems() {
        this.dissolve();
        return Stream.of(this.itemStacks);
    }

    @Override
    public boolean test(@Nullable ItemStack stack) {
        if (stack == null) {
            return false;
        }
        this.dissolve();
        for (ItemStack itemStack : this.itemStacks) {
            if (!itemStack.is(stack.getItem())) continue;
            return true;
        }
        return false;
    }

    public TagKey<Block> getTag() {
        return this.tag;
    }

    @Override
    public boolean isSimple() {
        return true;
    }

    @Override
    public IngredientType<?> getType() {
        return NeoForgeMod.BLOCK_TAG_INGREDIENT.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BlockTagIngredient)) {
            return false;
        }
        BlockTagIngredient that = (BlockTagIngredient)o;
        return this.tag.equals(that.tag);
    }

    public int hashCode() {
        return this.tag.hashCode();
    }
}

