/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.neoforged.neoforge.registries.datamaps.builtin.BiomeVillagerType;
import net.neoforged.neoforge.registries.datamaps.builtin.NeoForgeDataMaps;

public final class VillagerType {
    public static final VillagerType DESERT = VillagerType.register("desert");
    public static final VillagerType JUNGLE = VillagerType.register("jungle");
    public static final VillagerType PLAINS = VillagerType.register("plains");
    public static final VillagerType SAVANNA = VillagerType.register("savanna");
    public static final VillagerType SNOW = VillagerType.register("snow");
    public static final VillagerType SWAMP = VillagerType.register("swamp");
    public static final VillagerType TAIGA = VillagerType.register("taiga");
    private final String name;
    @Deprecated
    private static final Map<ResourceKey<Biome>, VillagerType> BY_BIOME = Util.make(Maps.newHashMap(), p_35834_ -> {
        p_35834_.put(Biomes.BADLANDS, DESERT);
        p_35834_.put(Biomes.DESERT, DESERT);
        p_35834_.put(Biomes.ERODED_BADLANDS, DESERT);
        p_35834_.put(Biomes.WOODED_BADLANDS, DESERT);
        p_35834_.put(Biomes.BAMBOO_JUNGLE, JUNGLE);
        p_35834_.put(Biomes.JUNGLE, JUNGLE);
        p_35834_.put(Biomes.SPARSE_JUNGLE, JUNGLE);
        p_35834_.put(Biomes.SAVANNA_PLATEAU, SAVANNA);
        p_35834_.put(Biomes.SAVANNA, SAVANNA);
        p_35834_.put(Biomes.WINDSWEPT_SAVANNA, SAVANNA);
        p_35834_.put(Biomes.DEEP_FROZEN_OCEAN, SNOW);
        p_35834_.put(Biomes.FROZEN_OCEAN, SNOW);
        p_35834_.put(Biomes.FROZEN_RIVER, SNOW);
        p_35834_.put(Biomes.ICE_SPIKES, SNOW);
        p_35834_.put(Biomes.SNOWY_BEACH, SNOW);
        p_35834_.put(Biomes.SNOWY_TAIGA, SNOW);
        p_35834_.put(Biomes.SNOWY_PLAINS, SNOW);
        p_35834_.put(Biomes.GROVE, SNOW);
        p_35834_.put(Biomes.SNOWY_SLOPES, SNOW);
        p_35834_.put(Biomes.FROZEN_PEAKS, SNOW);
        p_35834_.put(Biomes.JAGGED_PEAKS, SNOW);
        p_35834_.put(Biomes.SWAMP, SWAMP);
        p_35834_.put(Biomes.MANGROVE_SWAMP, SWAMP);
        p_35834_.put(Biomes.OLD_GROWTH_SPRUCE_TAIGA, TAIGA);
        p_35834_.put(Biomes.OLD_GROWTH_PINE_TAIGA, TAIGA);
        p_35834_.put(Biomes.WINDSWEPT_GRAVELLY_HILLS, TAIGA);
        p_35834_.put(Biomes.WINDSWEPT_HILLS, TAIGA);
        p_35834_.put(Biomes.TAIGA, TAIGA);
        p_35834_.put(Biomes.WINDSWEPT_FOREST, TAIGA);
    });

    public VillagerType(String p_35830_) {
        this.name = p_35830_;
    }

    public String toString() {
        return this.name;
    }

    private static VillagerType register(String p_35832_) {
        return Registry.register(BuiltInRegistries.VILLAGER_TYPE, ResourceLocation.withDefaultNamespace(p_35832_), new VillagerType(p_35832_));
    }

    public static VillagerType byBiome(Holder<Biome> p_204074_) {
        BiomeVillagerType fromDataMap = (BiomeVillagerType)p_204074_.getData(NeoForgeDataMaps.VILLAGER_TYPES);
        if (fromDataMap != null) {
            return fromDataMap.type();
        }
        return p_204074_.unwrapKey().map(BY_BIOME::get).orElse(PLAINS);
    }
}

