/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.common.asm.enumextension;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;

public final class EnumProxy<T extends Enum<T>> {
    private final Class<T> enumClass;
    private final List<Object> parameters;
    private volatile T enumValue;

    public EnumProxy(Class<T> enumClass, Object ... parameters) {
        this(enumClass, Arrays.asList(parameters));
    }

    public EnumProxy(Class<T> enumClass, List<Object> parameters) {
        this.enumClass = enumClass;
        this.parameters = parameters;
    }

    @ApiStatus.Internal
    public Object getParameter(int idx) {
        return this.parameters.get(idx);
    }

    public T getValue() {
        if (this.enumValue == null) {
            try {
                Class.forName(this.enumClass.getName(), true, this.enumClass.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return (T)((Enum)Objects.requireNonNull(this.enumValue, "Enum not initialized. Did you forget to configure the field holding this proxy as a parameter in the enum extension config file?"));
    }

    @ApiStatus.Internal
    public void setValue(T value) {
        this.enumValue = value;
    }
}

