/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.coremod;

import cpw.mods.modlauncher.api.ITransformer;
import cpw.mods.modlauncher.api.TargetType;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.script.Bindings;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import net.neoforged.coremod.CoreModTracker;
import net.neoforged.coremod.ICoreModScriptSource;
import net.neoforged.coremod.NashornFactory;
import net.neoforged.coremod.api.ASMAPI;
import net.neoforged.coremod.transformer.CoreModClassTransformer;
import net.neoforged.coremod.transformer.CoreModFieldTransformer;
import net.neoforged.coremod.transformer.CoreModMethodTransformer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class CoreMod {
    public static final Marker COREMODLOG = MarkerManager.getMarker((String)"COREMODLOG").addParents(new Marker[]{MarkerManager.getMarker((String)"COREMOD")});
    private final ICoreModScriptSource file;
    private final ScriptEngine scriptEngine;
    private Map<String, ? extends Bindings> javaScript;
    private boolean loaded = false;
    private Exception error;
    private Logger logger;

    CoreMod(ICoreModScriptSource file, ScriptEngine scriptEngine) {
        this.file = file;
        this.scriptEngine = scriptEngine;
    }

    public String getDebugSource() {
        return this.file.getDebugSource();
    }

    void initialize() {
        this.logger = LogManager.getLogger((String)("net.neoforged.coremod.CoreMod." + this.file.getOwnerId()));
        try {
            this.scriptEngine.eval(this.file.readCoreMod());
            CoreModTracker.setCoreMod(this);
            this.javaScript = (Map)((Invocable)((Object)this.scriptEngine)).invokeFunction("initializeCoreMod", new Object[0]);
            CoreModTracker.clearCoreMod();
            this.loaded = true;
        }
        catch (IOException | NoSuchMethodException | ScriptException e) {
            this.loaded = false;
            this.error = e;
        }
    }

    List<ITransformer<?>> buildTransformers() {
        if (!this.loaded) {
            return Collections.emptyList();
        }
        return this.javaScript.entrySet().stream().map(this::buildCore).collect(Collectors.toList());
    }

    private ITransformer<?> buildCore(Map.Entry<String, ? extends Bindings> entry) {
        String coreName = entry.getKey();
        Bindings data = entry.getValue();
        Map targetData = (Map)data.get("target");
        TargetType targetType = TargetType.byName((String)((String)targetData.get("type")));
        Bindings function = (Bindings)data.get("transformer");
        if (targetType.equals(TargetType.CLASS)) {
            Set<Object> targets;
            if (targetData.containsKey("names")) {
                Function names = NashornFactory.getFunction((Bindings)targetData.get("names"));
                targets = ((Map)names.apply(targetData)).values().stream().map(o -> (String)o).map(ITransformer.Target::targetClass).collect(Collectors.toSet());
            } else {
                targets = Stream.of(ITransformer.Target.targetClass((String)((String)targetData.get("name")))).collect(Collectors.toSet());
            }
            return new CoreModClassTransformer(this, coreName, (Set<ITransformer.Target<ClassNode>>)targets, NashornFactory.getFunction(function));
        }
        if (targetType.equals(TargetType.METHOD)) {
            Set<ITransformer.Target<MethodNode>> targets = Collections.singleton(ITransformer.Target.targetMethod((String)((String)targetData.get("class")), (String)ASMAPI.mapMethod((String)targetData.get("methodName")), (String)((String)targetData.get("methodDesc"))));
            return new CoreModMethodTransformer(this, coreName, targets, NashornFactory.getFunction(function));
        }
        if (targetType.equals(TargetType.FIELD)) {
            Set<ITransformer.Target<FieldNode>> targets = Collections.singleton(ITransformer.Target.targetField((String)((String)targetData.get("class")), (String)ASMAPI.mapField((String)targetData.get("fieldName"))));
            return new CoreModFieldTransformer(this, coreName, targets, NashornFactory.getFunction(function));
        }
        throw new RuntimeException("Unimplemented target type " + targetData);
    }

    public boolean hasError() {
        return !this.loaded;
    }

    public Exception getError() {
        return this.error;
    }

    public ICoreModScriptSource getFile() {
        return this.file;
    }

    public boolean loadAdditionalFile(String fileName) throws ScriptException, IOException {
        if (this.loaded) {
            return false;
        }
        Reader additional = this.file.getAdditionalFile(fileName);
        this.scriptEngine.eval(additional);
        return true;
    }

    @Nullable
    public Object loadAdditionalData(String fileName) throws ScriptException, IOException {
        int numChars;
        if (this.loaded) {
            return null;
        }
        Reader additional = this.file.getAdditionalFile(fileName);
        char[] buf = new char[4096];
        StringBuilder builder = new StringBuilder();
        while ((numChars = additional.read(buf)) >= 0) {
            builder.append(buf, 0, numChars);
        }
        String str = builder.toString();
        return this.scriptEngine.eval("tmp_json_loading_variable = " + str + ";");
    }

    public void logMessage(String level, String message, Object[] args) {
        this.logger.log(Level.getLevel((String)level), COREMODLOG, message, args);
    }
}

