/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.parsing.packrat;

import java.util.List;
import java.util.Optional;
import net.minecraft.util.parsing.packrat.Atom;
import net.minecraft.util.parsing.packrat.Control;
import net.minecraft.util.parsing.packrat.ParseState;
import net.minecraft.util.parsing.packrat.Scope;
import org.apache.commons.lang3.mutable.MutableBoolean;

public interface Term<S> {
    public boolean parse(ParseState<S> var1, Scope var2, Control var3);

    public static <S> Term<S> named(Atom<?> p_335922_) {
        return new Reference(p_335922_);
    }

    public static <S, T> Term<S> marker(Atom<T> p_335833_, T p_335787_) {
        return new Marker(p_335833_, p_335787_);
    }

    @SafeVarargs
    public static <S> Term<S> sequence(Term<S> ... p_336132_) {
        return new Sequence<S>(List.of(p_336132_));
    }

    @SafeVarargs
    public static <S> Term<S> alternative(Term<S> ... p_335455_) {
        return new Alternative<S>(List.of(p_335455_));
    }

    public static <S> Term<S> optional(Term<S> p_335471_) {
        return new Maybe<S>(p_335471_);
    }

    public static <S> Term<S> cut() {
        return new Term<S>(){

            @Override
            public boolean parse(ParseState<S> p_335490_, Scope p_335377_, Control p_336074_) {
                p_336074_.cut();
                return true;
            }

            public String toString() {
                return "\u2191";
            }
        };
    }

    public static <S> Term<S> empty() {
        return new Term<S>(){

            @Override
            public boolean parse(ParseState<S> p_335978_, Scope p_335744_, Control p_335881_) {
                return true;
            }

            public String toString() {
                return "\u03b5";
            }
        };
    }

    public record Reference<S, T>(Atom<T> name) implements Term<S>
    {
        @Override
        public boolean parse(ParseState<S> p_335637_, Scope p_336134_, Control p_336055_) {
            Optional<T> $$3 = p_335637_.parse(this.name);
            if ($$3.isEmpty()) {
                return false;
            }
            p_336134_.put(this.name, $$3.get());
            return true;
        }
    }

    public record Marker<S, T>(Atom<T> name, T value) implements Term<S>
    {
        @Override
        public boolean parse(ParseState<S> p_335600_, Scope p_335485_, Control p_335375_) {
            p_335485_.put(this.name, this.value);
            return true;
        }
    }

    public record Sequence<S>(List<Term<S>> elements) implements Term<S>
    {
        @Override
        public boolean parse(ParseState<S> p_336111_, Scope p_335911_, Control p_336188_) {
            int $$3 = p_336111_.mark();
            for (Term<S> $$4 : this.elements) {
                if ($$4.parse(p_336111_, p_335911_, p_336188_)) continue;
                p_336111_.restore($$3);
                return false;
            }
            return true;
        }
    }

    public record Alternative<S>(List<Term<S>> elements) implements Term<S>
    {
        @Override
        public boolean parse(ParseState<S> p_336147_, Scope p_335902_, Control p_335396_) {
            MutableBoolean $$3 = new MutableBoolean();
            Control $$4 = () -> ((MutableBoolean)$$3).setTrue();
            int $$5 = p_336147_.mark();
            for (Term<S> $$6 : this.elements) {
                if ($$3.isTrue()) break;
                Scope $$7 = new Scope();
                if ($$6.parse(p_336147_, $$7, $$4)) {
                    p_335902_.putAll($$7);
                    return true;
                }
                p_336147_.restore($$5);
            }
            return false;
        }
    }

    public record Maybe<S>(Term<S> term) implements Term<S>
    {
        @Override
        public boolean parse(ParseState<S> p_335415_, Scope p_335550_, Control p_336000_) {
            int $$3 = p_335415_.mark();
            if (!this.term.parse(p_335415_, p_335550_, p_336000_)) {
                p_335415_.restore($$3);
            }
            return true;
        }
    }
}

