/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.eventlog;

import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import org.slf4j.Logger;

public class EventLogDirectory {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final int COMPRESS_BUFFER_SIZE = 4096;
    private static final String COMPRESSED_EXTENSION = ".gz";
    private final Path root;
    private final String extension;

    private EventLogDirectory(Path p_261546_, String p_261467_) {
        this.root = p_261546_;
        this.extension = p_261467_;
    }

    public static EventLogDirectory open(Path p_261743_, String p_261659_) throws IOException {
        Files.createDirectories(p_261743_, new FileAttribute[0]);
        return new EventLogDirectory(p_261743_, p_261659_);
    }

    public FileList listFiles() throws IOException {
        try (Stream<Path> $$0 = Files.list(this.root);){
            FileList fileList = new FileList($$0.filter(p_262170_ -> Files.isRegularFile(p_262170_, new LinkOption[0])).map(this::parseFile).filter(Objects::nonNull).toList());
            return fileList;
        }
    }

    @Nullable
    private File parseFile(Path p_261985_) {
        String $$1 = p_261985_.getFileName().toString();
        int $$2 = $$1.indexOf(46);
        if ($$2 == -1) {
            return null;
        }
        FileId $$3 = FileId.parse($$1.substring(0, $$2));
        if ($$3 != null) {
            String $$4 = $$1.substring($$2);
            if ($$4.equals(this.extension)) {
                return new RawFile(p_261985_, $$3);
            }
            if ($$4.equals(this.extension + COMPRESSED_EXTENSION)) {
                return new CompressedFile(p_261985_, $$3);
            }
        }
        return null;
    }

    static void tryCompress(Path p_261741_, Path p_262101_) throws IOException {
        if (Files.exists(p_262101_, new LinkOption[0])) {
            throw new IOException("Compressed target file already exists: " + String.valueOf(p_262101_));
        }
        try (FileChannel $$2 = FileChannel.open(p_261741_, StandardOpenOption.WRITE, StandardOpenOption.READ);){
            FileLock $$3 = $$2.tryLock();
            if ($$3 == null) {
                throw new IOException("Raw log file is already locked, cannot compress: " + String.valueOf(p_261741_));
            }
            EventLogDirectory.writeCompressed($$2, p_262101_);
            $$2.truncate(0L);
        }
        Files.delete(p_261741_);
    }

    private static void writeCompressed(ReadableByteChannel p_262066_, Path p_262054_) throws IOException {
        try (GZIPOutputStream $$2 = new GZIPOutputStream(Files.newOutputStream(p_262054_, new OpenOption[0]));){
            byte[] $$3 = new byte[4096];
            ByteBuffer $$4 = ByteBuffer.wrap($$3);
            while (p_262066_.read($$4) >= 0) {
                $$4.flip();
                ((OutputStream)$$2).write($$3, 0, $$4.limit());
                $$4.clear();
            }
        }
    }

    public RawFile createNewFile(LocalDate p_261865_) throws IOException {
        FileId $$3;
        int $$1 = 1;
        Set<FileId> $$2 = this.listFiles().ids();
        while ($$2.contains($$3 = new FileId(p_261865_, $$1++))) {
        }
        RawFile $$4 = new RawFile(this.root.resolve($$3.toFileName(this.extension)), $$3);
        Files.createFile($$4.path(), new FileAttribute[0]);
        return $$4;
    }

    public static class FileList
    implements Iterable<File> {
        private final List<File> files;

        FileList(List<File> p_261941_) {
            this.files = new ArrayList<File>(p_261941_);
        }

        public FileList prune(LocalDate p_261825_, int p_261918_) {
            this.files.removeIf(p_261494_ -> {
                FileId $$3 = p_261494_.id();
                LocalDate $$4 = $$3.date().plusDays(p_261918_);
                if (!p_261825_.isBefore($$4)) {
                    try {
                        Files.delete(p_261494_.path());
                        return true;
                    }
                    catch (IOException $$5) {
                        LOGGER.warn("Failed to delete expired event log file: {}", (Object)p_261494_.path(), (Object)$$5);
                    }
                }
                return false;
            });
            return this;
        }

        public FileList compressAll() {
            ListIterator<File> $$0 = this.files.listIterator();
            while ($$0.hasNext()) {
                File $$1 = $$0.next();
                try {
                    $$0.set($$1.compress());
                }
                catch (IOException $$2) {
                    LOGGER.warn("Failed to compress event log file: {}", (Object)$$1.path(), (Object)$$2);
                }
            }
            return this;
        }

        @Override
        public Iterator<File> iterator() {
            return this.files.iterator();
        }

        public Stream<File> stream() {
            return this.files.stream();
        }

        public Set<FileId> ids() {
            return this.files.stream().map(File::id).collect(Collectors.toSet());
        }
    }

    public record FileId(LocalDate date, int index) {
        private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.BASIC_ISO_DATE;

        @Nullable
        public static FileId parse(String p_261762_) {
            int $$1 = p_261762_.indexOf("-");
            if ($$1 == -1) {
                return null;
            }
            String $$2 = p_261762_.substring(0, $$1);
            String $$3 = p_261762_.substring($$1 + 1);
            try {
                return new FileId(LocalDate.parse($$2, DATE_FORMATTER), Integer.parseInt($$3));
            }
            catch (NumberFormatException | DateTimeParseException $$4) {
                return null;
            }
        }

        @Override
        public String toString() {
            return DATE_FORMATTER.format(this.date) + "-" + this.index;
        }

        public String toFileName(String p_261982_) {
            return String.valueOf(this) + p_261982_;
        }
    }

    public record RawFile(Path path, FileId id) implements File
    {
        public FileChannel openChannel() throws IOException {
            return FileChannel.open(this.path, StandardOpenOption.WRITE, StandardOpenOption.READ);
        }

        @Override
        @Nullable
        public Reader openReader() throws IOException {
            return Files.exists(this.path, new LinkOption[0]) ? Files.newBufferedReader(this.path) : null;
        }

        @Override
        public CompressedFile compress() throws IOException {
            Path $$0 = this.path.resolveSibling(this.path.getFileName().toString() + EventLogDirectory.COMPRESSED_EXTENSION);
            EventLogDirectory.tryCompress(this.path, $$0);
            return new CompressedFile($$0, this.id);
        }
    }

    public record CompressedFile(Path path, FileId id) implements File
    {
        @Override
        @Nullable
        public Reader openReader() throws IOException {
            if (!Files.exists(this.path, new LinkOption[0])) {
                return null;
            }
            return new BufferedReader(new InputStreamReader(new GZIPInputStream(Files.newInputStream(this.path, new OpenOption[0]))));
        }

        @Override
        public CompressedFile compress() {
            return this;
        }
    }

    public static interface File {
        public Path path();

        public FileId id();

        @Nullable
        public Reader openReader() throws IOException;

        public CompressedFile compress() throws IOException;
    }
}

