/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.locale;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.StringDecomposer;
import org.slf4j.Logger;

public abstract class Language {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new Gson();
    private static final Pattern UNSUPPORTED_FORMAT_PATTERN = Pattern.compile("%(\\d+\\$)?[\\d.]*[df]");
    public static final String DEFAULT = "en_us";
    private static volatile Language instance = Language.loadDefault();

    private static Language loadDefault() {
        ImmutableMap.Builder $$0 = ImmutableMap.builder();
        BiConsumer<String, String> $$1 = (arg_0, arg_1) -> ((ImmutableMap.Builder)$$0).put(arg_0, arg_1);
        Language.parseTranslations($$1, "/assets/minecraft/lang/en_us.json");
        ImmutableMap $$2 = $$0.build();
        return new Language((Map)$$2){
            final /* synthetic */ Map val$storage;
            {
                this.val$storage = map;
            }

            @Override
            public String getOrDefault(String p_128127_, String p_265421_) {
                return this.val$storage.getOrDefault(p_128127_, p_265421_);
            }

            @Override
            public boolean has(String p_128135_) {
                return this.val$storage.containsKey(p_128135_);
            }

            @Override
            public boolean isDefaultRightToLeft() {
                return false;
            }

            @Override
            public FormattedCharSequence getVisualOrder(FormattedText p_128129_) {
                return p_128132_ -> p_128129_.visit((p_177835_, p_177836_) -> StringDecomposer.iterateFormatted(p_177836_, p_177835_, p_128132_) ? Optional.empty() : FormattedText.STOP_ITERATION, Style.EMPTY).isPresent();
            }
        };
    }

    private static void parseTranslations(BiConsumer<String, String> p_282031_, String p_283638_) {
        try (InputStream $$2 = Language.class.getResourceAsStream(p_283638_);){
            Language.loadFromJson($$2, p_282031_);
        }
        catch (JsonParseException | IOException $$3) {
            LOGGER.error("Couldn't read strings from {}", (Object)p_283638_, (Object)$$3);
        }
    }

    public static void loadFromJson(InputStream p_128109_, BiConsumer<String, String> p_128110_) {
        JsonObject $$2 = (JsonObject)GSON.fromJson((Reader)new InputStreamReader(p_128109_, StandardCharsets.UTF_8), JsonObject.class);
        for (Map.Entry $$3 : $$2.entrySet()) {
            String $$4 = UNSUPPORTED_FORMAT_PATTERN.matcher(GsonHelper.convertToString((JsonElement)$$3.getValue(), (String)$$3.getKey())).replaceAll("%$1s");
            p_128110_.accept((String)$$3.getKey(), $$4);
        }
    }

    public static Language getInstance() {
        return instance;
    }

    public static void inject(Language p_128115_) {
        instance = p_128115_;
    }

    public String getOrDefault(String p_128111_) {
        return this.getOrDefault(p_128111_, p_128111_);
    }

    public abstract String getOrDefault(String var1, String var2);

    public abstract boolean has(String var1);

    public abstract boolean isDefaultRightToLeft();

    public abstract FormattedCharSequence getVisualOrder(FormattedText var1);

    public List<FormattedCharSequence> getVisualOrder(List<FormattedText> p_128113_) {
        return (List)p_128113_.stream().map(this::getVisualOrder).collect(ImmutableList.toImmutableList());
    }
}

